// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.networkmanager.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.networkmanager.model.*
import aws.sdk.kotlin.services.networkmanager.model.AcceptAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.AcceptAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.AssociateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.AssociateCustomerGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateCustomerGatewayResponse
import aws.sdk.kotlin.services.networkmanager.model.AssociateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateLinkResponse
import aws.sdk.kotlin.services.networkmanager.model.AssociateTransitGatewayConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectionResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateCoreNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateDeviceRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateDeviceResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateGlobalNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateGlobalNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateLinkResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateSiteRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateSiteResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateSiteToSiteVpnAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateTransitGatewayPeeringRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateTransitGatewayPeeringResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateTransitGatewayRouteTableAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.CreateVpcAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.CreateVpcAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteCoreNetworkPolicyVersionRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteCoreNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteDeviceRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteDeviceResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteGlobalNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteGlobalNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteLinkResponse
import aws.sdk.kotlin.services.networkmanager.model.DeletePeeringRequest
import aws.sdk.kotlin.services.networkmanager.model.DeletePeeringResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.networkmanager.model.DeleteSiteRequest
import aws.sdk.kotlin.services.networkmanager.model.DeleteSiteResponse
import aws.sdk.kotlin.services.networkmanager.model.DeregisterTransitGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.DeregisterTransitGatewayResponse
import aws.sdk.kotlin.services.networkmanager.model.DescribeGlobalNetworksRequest
import aws.sdk.kotlin.services.networkmanager.model.DescribeGlobalNetworksResponse
import aws.sdk.kotlin.services.networkmanager.model.DisassociateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.DisassociateCustomerGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateCustomerGatewayResponse
import aws.sdk.kotlin.services.networkmanager.model.DisassociateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateLinkResponse
import aws.sdk.kotlin.services.networkmanager.model.DisassociateTransitGatewayConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.DisassociateTransitGatewayConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.ExecuteCoreNetworkChangeSetRequest
import aws.sdk.kotlin.services.networkmanager.model.ExecuteCoreNetworkChangeSetResponse
import aws.sdk.kotlin.services.networkmanager.model.GetConnectAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerResponse
import aws.sdk.kotlin.services.networkmanager.model.GetConnectionsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectionsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeEventsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeSetRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeSetResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkPolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkPolicyResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCustomerGatewayAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetDevicesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetDevicesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetLinkAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetLinkAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetLinksRequest
import aws.sdk.kotlin.services.networkmanager.model.GetLinksResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceCountsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceCountsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceRelationshipsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkRoutesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkRoutesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkTelemetryRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkTelemetryResponse
import aws.sdk.kotlin.services.networkmanager.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.networkmanager.model.GetRouteAnalysisRequest
import aws.sdk.kotlin.services.networkmanager.model.GetRouteAnalysisResponse
import aws.sdk.kotlin.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetSiteToSiteVpnAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.GetSitesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetSitesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayPeeringRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayPeeringResponse
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRegistrationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRouteTableAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.GetVpcAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.GetVpcAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.ListAttachmentsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListAttachmentsResponse
import aws.sdk.kotlin.services.networkmanager.model.ListConnectPeersRequest
import aws.sdk.kotlin.services.networkmanager.model.ListConnectPeersResponse
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworksRequest
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworksResponse
import aws.sdk.kotlin.services.networkmanager.model.ListOrganizationServiceAccessStatusRequest
import aws.sdk.kotlin.services.networkmanager.model.ListOrganizationServiceAccessStatusResponse
import aws.sdk.kotlin.services.networkmanager.model.ListPeeringsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListPeeringsResponse
import aws.sdk.kotlin.services.networkmanager.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkmanager.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.networkmanager.model.PutCoreNetworkPolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.PutCoreNetworkPolicyResponse
import aws.sdk.kotlin.services.networkmanager.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.networkmanager.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.networkmanager.model.RegisterTransitGatewayRequest
import aws.sdk.kotlin.services.networkmanager.model.RegisterTransitGatewayResponse
import aws.sdk.kotlin.services.networkmanager.model.RejectAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.RejectAttachmentResponse
import aws.sdk.kotlin.services.networkmanager.model.RestoreCoreNetworkPolicyVersionRequest
import aws.sdk.kotlin.services.networkmanager.model.RestoreCoreNetworkPolicyVersionResponse
import aws.sdk.kotlin.services.networkmanager.model.StartOrganizationServiceAccessUpdateRequest
import aws.sdk.kotlin.services.networkmanager.model.StartOrganizationServiceAccessUpdateResponse
import aws.sdk.kotlin.services.networkmanager.model.StartRouteAnalysisRequest
import aws.sdk.kotlin.services.networkmanager.model.StartRouteAnalysisResponse
import aws.sdk.kotlin.services.networkmanager.model.TagResourceRequest
import aws.sdk.kotlin.services.networkmanager.model.TagResourceResponse
import aws.sdk.kotlin.services.networkmanager.model.UntagResourceRequest
import aws.sdk.kotlin.services.networkmanager.model.UntagResourceResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateConnectionRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateConnectionResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateCoreNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateCoreNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateDeviceRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateDeviceResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateGlobalNetworkRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateGlobalNetworkResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateLinkRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateLinkResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateNetworkResourceMetadataRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateNetworkResourceMetadataResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateSiteRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateSiteResponse
import aws.sdk.kotlin.services.networkmanager.model.UpdateVpcAttachmentRequest
import aws.sdk.kotlin.services.networkmanager.model.UpdateVpcAttachmentResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services enables you to centrally manage your Amazon Web Services Cloud WAN core network and your Transit Gateway network across Amazon Web Services accounts, Regions, and on-premises locations.
 */
public interface NetworkManagerClient : SdkClient {

    override val serviceName: String
        get() = "NetworkManager"
    /**
     * NetworkManagerClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): NetworkManagerClient {
            val config = Config.Builder().apply(block).build()
            return DefaultNetworkManagerClient(config)
        }

        public operator fun invoke(config: Config): NetworkManagerClient = DefaultNetworkManagerClient(config)

        /**
         * Construct a [NetworkManagerClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): NetworkManagerClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultNetworkManagerClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts a core network attachment request.
     *
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a core network.
     */
    public suspend fun acceptAttachment(input: AcceptAttachmentRequest): AcceptAttachmentResponse

    /**
     * Associates a core network Connect peer with a device and optionally, with a link.
     *
     * If you specify a link, it must be associated with the specified device. You can only associate core network Connect peers that have been created on a core network Connect attachment on a core network.
     */
    public suspend fun associateConnectPeer(input: AssociateConnectPeerRequest): AssociateConnectPeerResponse

    /**
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.
     *
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core network registered in your global network. When you register a transit gateway or core network, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the [DescribeVpnConnections](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html) EC2 API and filter by `transit-gateway-id`.
     *
     * You cannot associate a customer gateway with more than one device and link.
     */
    public suspend fun associateCustomerGateway(input: AssociateCustomerGatewayRequest): AssociateCustomerGatewayResponse

    /**
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
     */
    public suspend fun associateLink(input: AssociateLinkRequest): AssociateLinkResponse

    /**
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device.
     *
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network.
     *
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     */
    public suspend fun associateTransitGatewayConnectPeer(input: AssociateTransitGatewayConnectPeerRequest): AssociateTransitGatewayConnectPeerResponse

    /**
     * Creates a core network Connect attachment from a specified core network attachment.
     *
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the underlying transport mechanism.
     */
    public suspend fun createConnectAttachment(input: CreateConnectAttachmentRequest): CreateConnectAttachmentResponse

    /**
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     */
    public suspend fun createConnectPeer(input: CreateConnectPeerRequest): CreateConnectPeerResponse

    /**
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.
     */
    public suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     */
    public suspend fun createCoreNetwork(input: CreateCoreNetworkRequest): CreateCoreNetworkResponse

    /**
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
     */
    public suspend fun createDevice(input: CreateDeviceRequest): CreateDeviceResponse

    /**
     * Creates a new, empty global network.
     */
    public suspend fun createGlobalNetwork(input: CreateGlobalNetworkRequest = CreateGlobalNetworkRequest {}): CreateGlobalNetworkResponse

    /**
     * Creates a new link for a specified site.
     */
    public suspend fun createLink(input: CreateLinkRequest): CreateLinkResponse

    /**
     * Creates a new site in a global network.
     */
    public suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse

    /**
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     */
    public suspend fun createSiteToSiteVpnAttachment(input: CreateSiteToSiteVpnAttachmentRequest): CreateSiteToSiteVpnAttachmentResponse

    /**
     * Creates a transit gateway peering connection.
     */
    public suspend fun createTransitGatewayPeering(input: CreateTransitGatewayPeeringRequest): CreateTransitGatewayPeeringResponse

    /**
     * Creates a transit gateway route table attachment.
     */
    public suspend fun createTransitGatewayRouteTableAttachment(input: CreateTransitGatewayRouteTableAttachmentRequest): CreateTransitGatewayRouteTableAttachmentResponse

    /**
     * Creates a VPC attachment on an edge location of a core network.
     */
    public suspend fun createVpcAttachment(input: CreateVpcAttachmentRequest): CreateVpcAttachmentResponse

    /**
     * Deletes an attachment. Supports all attachment types.
     */
    public suspend fun deleteAttachment(input: DeleteAttachmentRequest): DeleteAttachmentResponse

    /**
     * Deletes a Connect peer.
     */
    public suspend fun deleteConnectPeer(input: DeleteConnectPeerRequest): DeleteConnectPeerResponse

    /**
     * Deletes the specified connection in your global network.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.
     */
    public suspend fun deleteCoreNetwork(input: DeleteCoreNetworkRequest): DeleteCoreNetworkResponse

    /**
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     */
    public suspend fun deleteCoreNetworkPolicyVersion(input: DeleteCoreNetworkPolicyVersionRequest): DeleteCoreNetworkPolicyVersionResponse

    /**
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     */
    public suspend fun deleteDevice(input: DeleteDeviceRequest): DeleteDeviceResponse

    /**
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites), deregister all transit gateways, and delete any core networks.
     */
    public suspend fun deleteGlobalNetwork(input: DeleteGlobalNetworkRequest): DeleteGlobalNetworkResponse

    /**
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     */
    public suspend fun deleteLink(input: DeleteLinkRequest): DeleteLinkResponse

    /**
     * Deletes an existing peering connection.
     */
    public suspend fun deletePeering(input: DeletePeeringRequest): DeletePeeringResponse

    /**
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes an existing site. The site cannot be associated with any device or link.
     */
    public suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse

    /**
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
     */
    public suspend fun deregisterTransitGateway(input: DeregisterTransitGatewayRequest): DeregisterTransitGatewayResponse

    /**
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate `Get*` action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.
     */
    public suspend fun describeGlobalNetworks(input: DescribeGlobalNetworksRequest = DescribeGlobalNetworksRequest {}): DescribeGlobalNetworksResponse

    /**
     * Disassociates a core network Connect peer from a device and a link.
     */
    public suspend fun disassociateConnectPeer(input: DisassociateConnectPeerRequest): DisassociateConnectPeerResponse

    /**
     * Disassociates a customer gateway from a device and a link.
     */
    public suspend fun disassociateCustomerGateway(input: DisassociateCustomerGatewayRequest): DisassociateCustomerGatewayResponse

    /**
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
     */
    public suspend fun disassociateLink(input: DisassociateLinkRequest): DisassociateLinkResponse

    /**
     * Disassociates a transit gateway Connect peer from a device and link.
     */
    public suspend fun disassociateTransitGatewayConnectPeer(input: DisassociateTransitGatewayConnectPeerRequest): DisassociateTransitGatewayConnectPeerResponse

    /**
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     */
    public suspend fun executeCoreNetworkChangeSet(input: ExecuteCoreNetworkChangeSetRequest): ExecuteCoreNetworkChangeSetResponse

    /**
     * Returns information about a core network Connect attachment.
     */
    public suspend fun getConnectAttachment(input: GetConnectAttachmentRequest): GetConnectAttachmentResponse

    /**
     * Returns information about a core network Connect peer.
     */
    public suspend fun getConnectPeer(input: GetConnectPeerRequest): GetConnectPeerResponse

    /**
     * Returns information about a core network Connect peer associations.
     */
    public suspend fun getConnectPeerAssociations(input: GetConnectPeerAssociationsRequest): GetConnectPeerAssociationsResponse

    /**
     * Gets information about one or more of your connections in a global network.
     */
    public suspend fun getConnections(input: GetConnectionsRequest): GetConnectionsResponse

    /**
     * Returns information about the LIVE policy for a core network.
     */
    public suspend fun getCoreNetwork(input: GetCoreNetworkRequest): GetCoreNetworkResponse

    /**
     * Returns information about a core network change event.
     */
    public suspend fun getCoreNetworkChangeEvents(input: GetCoreNetworkChangeEventsRequest): GetCoreNetworkChangeEventsResponse

    /**
     * Returns a change set between the LIVE core network policy and a submitted policy.
     */
    public suspend fun getCoreNetworkChangeSet(input: GetCoreNetworkChangeSetRequest): GetCoreNetworkChangeSetResponse

    /**
     * Returns details about a core network policy. You can get details about your current live policy or any previous policy version.
     */
    public suspend fun getCoreNetworkPolicy(input: GetCoreNetworkPolicyRequest): GetCoreNetworkPolicyResponse

    /**
     * Gets the association information for customer gateways that are associated with devices and links in your global network.
     */
    public suspend fun getCustomerGatewayAssociations(input: GetCustomerGatewayAssociationsRequest): GetCustomerGatewayAssociationsResponse

    /**
     * Gets information about one or more of your devices in a global network.
     */
    public suspend fun getDevices(input: GetDevicesRequest): GetDevicesResponse

    /**
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     */
    public suspend fun getLinkAssociations(input: GetLinkAssociationsRequest): GetLinkAssociationsResponse

    /**
     * Gets information about one or more links in a specified global network.
     *
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.
     */
    public suspend fun getLinks(input: GetLinksRequest): GetLinksResponse

    /**
     * Gets the count of network resources, by resource type, for the specified global network.
     */
    public suspend fun getNetworkResourceCounts(input: GetNetworkResourceCountsRequest): GetNetworkResourceCountsResponse

    /**
     * Gets the network resource relationships for the specified global network.
     */
    public suspend fun getNetworkResourceRelationships(input: GetNetworkResourceRelationshipsRequest): GetNetworkResourceRelationshipsResponse

    /**
     * Describes the network resources for the specified global network.
     *
     * The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.
     */
    public suspend fun getNetworkResources(input: GetNetworkResourcesRequest): GetNetworkResourcesResponse

    /**
     * Gets the network routes of the specified global network.
     */
    public suspend fun getNetworkRoutes(input: GetNetworkRoutesRequest): GetNetworkRoutesResponse

    /**
     * Gets the network telemetry of the specified global network.
     */
    public suspend fun getNetworkTelemetry(input: GetNetworkTelemetryRequest): GetNetworkTelemetryResponse

    /**
     * Returns information about a resource policy.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Gets information about the specified route analysis.
     */
    public suspend fun getRouteAnalysis(input: GetRouteAnalysisRequest): GetRouteAnalysisResponse

    /**
     * Returns information about a site-to-site VPN attachment.
     */
    public suspend fun getSiteToSiteVpnAttachment(input: GetSiteToSiteVpnAttachmentRequest): GetSiteToSiteVpnAttachmentResponse

    /**
     * Gets information about one or more of your sites in a global network.
     */
    public suspend fun getSites(input: GetSitesRequest): GetSitesResponse

    /**
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     */
    public suspend fun getTransitGatewayConnectPeerAssociations(input: GetTransitGatewayConnectPeerAssociationsRequest): GetTransitGatewayConnectPeerAssociationsResponse

    /**
     * Returns information about a transit gateway peer.
     */
    public suspend fun getTransitGatewayPeering(input: GetTransitGatewayPeeringRequest): GetTransitGatewayPeeringResponse

    /**
     * Gets information about the transit gateway registrations in a specified global network.
     */
    public suspend fun getTransitGatewayRegistrations(input: GetTransitGatewayRegistrationsRequest): GetTransitGatewayRegistrationsResponse

    /**
     * Returns information about a transit gateway route table attachment.
     */
    public suspend fun getTransitGatewayRouteTableAttachment(input: GetTransitGatewayRouteTableAttachmentRequest): GetTransitGatewayRouteTableAttachmentResponse

    /**
     * Returns information about a VPC attachment.
     */
    public suspend fun getVpcAttachment(input: GetVpcAttachmentRequest): GetVpcAttachmentResponse

    /**
     * Returns a list of core network attachments.
     */
    public suspend fun listAttachments(input: ListAttachmentsRequest = ListAttachmentsRequest {}): ListAttachmentsResponse

    /**
     * Returns a list of core network Connect peers.
     */
    public suspend fun listConnectPeers(input: ListConnectPeersRequest = ListConnectPeersRequest {}): ListConnectPeersResponse

    /**
     * Returns a list of core network policy versions.
     */
    public suspend fun listCoreNetworkPolicyVersions(input: ListCoreNetworkPolicyVersionsRequest): ListCoreNetworkPolicyVersionsResponse

    /**
     * Returns a list of owned and shared core networks.
     */
    public suspend fun listCoreNetworks(input: ListCoreNetworksRequest = ListCoreNetworksRequest {}): ListCoreNetworksResponse

    /**
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services Organization.
     */
    public suspend fun listOrganizationServiceAccessStatus(input: ListOrganizationServiceAccessStatusRequest = ListOrganizationServiceAccessStatusRequest {}): ListOrganizationServiceAccessStatusResponse

    /**
     * Lists the peerings for a core network.
     */
    public suspend fun listPeerings(input: ListPeeringsRequest = ListPeeringsRequest {}): ListPeeringsResponse

    /**
     * Lists the tags for a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.
     */
    public suspend fun putCoreNetworkPolicy(input: PutCoreNetworkPolicyRequest): PutCoreNetworkPolicyResponse

    /**
     * Creates or updates a resource policy.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.
     */
    public suspend fun registerTransitGateway(input: RegisterTransitGatewayRequest): RegisterTransitGatewayResponse

    /**
     * Rejects a core network attachment request.
     */
    public suspend fun rejectAttachment(input: RejectAttachmentRequest): RejectAttachmentResponse

    /**
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.
     */
    public suspend fun restoreCoreNetworkPolicyVersion(input: RestoreCoreNetworkPolicyVersionRequest): RestoreCoreNetworkPolicyVersionResponse

    /**
     * Enables for the Network Manager service for an Amazon Web Services Organization. This can only be called by a management account within the organization.
     */
    public suspend fun startOrganizationServiceAccessUpdate(input: StartOrganizationServiceAccessUpdateRequest): StartOrganizationServiceAccessUpdateResponse

    /**
     * Starts analyzing the routing path between the specified source and destination. For more information, see [Route Analyzer](https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html).
     */
    public suspend fun startRouteAnalysis(input: StartRouteAnalysisRequest): StartRouteAnalysisResponse

    /**
     * Tags a specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.
     */
    public suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse

    /**
     * Updates the description of a core network.
     */
    public suspend fun updateCoreNetwork(input: UpdateCoreNetworkRequest): UpdateCoreNetworkResponse

    /**
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
     */
    public suspend fun updateDevice(input: UpdateDeviceRequest): UpdateDeviceResponse

    /**
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     */
    public suspend fun updateGlobalNetwork(input: UpdateGlobalNetworkRequest): UpdateGlobalNetworkResponse

    /**
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
     */
    public suspend fun updateLink(input: UpdateLinkRequest): UpdateLinkResponse

    /**
     * Updates the resource metadata for the specified global network.
     */
    public suspend fun updateNetworkResourceMetadata(input: UpdateNetworkResourceMetadataRequest): UpdateNetworkResourceMetadataResponse

    /**
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
     */
    public suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse

    /**
     * Updates a VPC attachment.
     */
    public suspend fun updateVpcAttachment(input: UpdateVpcAttachmentRequest): UpdateVpcAttachmentResponse
}

/**
 * Accepts a core network attachment request.
 *
 * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a core network.
 */
public suspend inline fun NetworkManagerClient.acceptAttachment(crossinline block: AcceptAttachmentRequest.Builder.() -> Unit): AcceptAttachmentResponse = acceptAttachment(AcceptAttachmentRequest.Builder().apply(block).build())

/**
 * Associates a core network Connect peer with a device and optionally, with a link.
 *
 * If you specify a link, it must be associated with the specified device. You can only associate core network Connect peers that have been created on a core network Connect attachment on a core network.
 */
public suspend inline fun NetworkManagerClient.associateConnectPeer(crossinline block: AssociateConnectPeerRequest.Builder.() -> Unit): AssociateConnectPeerResponse = associateConnectPeer(AssociateConnectPeerRequest.Builder().apply(block).build())

/**
 * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.
 *
 * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core network registered in your global network. When you register a transit gateway or core network, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the [DescribeVpnConnections](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html) EC2 API and filter by `transit-gateway-id`.
 *
 * You cannot associate a customer gateway with more than one device and link.
 */
public suspend inline fun NetworkManagerClient.associateCustomerGateway(crossinline block: AssociateCustomerGatewayRequest.Builder.() -> Unit): AssociateCustomerGatewayResponse = associateCustomerGateway(AssociateCustomerGatewayRequest.Builder().apply(block).build())

/**
 * Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
 */
public suspend inline fun NetworkManagerClient.associateLink(crossinline block: AssociateLinkRequest.Builder.() -> Unit): AssociateLinkResponse = associateLink(AssociateLinkRequest.Builder().apply(block).build())

/**
 * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device.
 *
 * You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network.
 *
 * You cannot associate a transit gateway Connect peer with more than one device and link.
 */
public suspend inline fun NetworkManagerClient.associateTransitGatewayConnectPeer(crossinline block: AssociateTransitGatewayConnectPeerRequest.Builder.() -> Unit): AssociateTransitGatewayConnectPeerResponse = associateTransitGatewayConnectPeer(AssociateTransitGatewayConnectPeerRequest.Builder().apply(block).build())

/**
 * Creates a core network Connect attachment from a specified core network attachment.
 *
 * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the underlying transport mechanism.
 */
public suspend inline fun NetworkManagerClient.createConnectAttachment(crossinline block: CreateConnectAttachmentRequest.Builder.() -> Unit): CreateConnectAttachmentResponse = createConnectAttachment(CreateConnectAttachmentRequest.Builder().apply(block).build())

/**
 * Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
 */
public suspend inline fun NetworkManagerClient.createConnectPeer(crossinline block: CreateConnectPeerRequest.Builder.() -> Unit): CreateConnectPeerResponse = createConnectPeer(CreateConnectPeerRequest.Builder().apply(block).build())

/**
 * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.
 */
public suspend inline fun NetworkManagerClient.createConnection(crossinline block: CreateConnectionRequest.Builder.() -> Unit): CreateConnectionResponse = createConnection(CreateConnectionRequest.Builder().apply(block).build())

/**
 * Creates a core network as part of your global network, and optionally, with a core network policy.
 */
public suspend inline fun NetworkManagerClient.createCoreNetwork(crossinline block: CreateCoreNetworkRequest.Builder.() -> Unit): CreateCoreNetworkResponse = createCoreNetwork(CreateCoreNetworkRequest.Builder().apply(block).build())

/**
 * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
 */
public suspend inline fun NetworkManagerClient.createDevice(crossinline block: CreateDeviceRequest.Builder.() -> Unit): CreateDeviceResponse = createDevice(CreateDeviceRequest.Builder().apply(block).build())

/**
 * Creates a new, empty global network.
 */
public suspend inline fun NetworkManagerClient.createGlobalNetwork(crossinline block: CreateGlobalNetworkRequest.Builder.() -> Unit): CreateGlobalNetworkResponse = createGlobalNetwork(CreateGlobalNetworkRequest.Builder().apply(block).build())

/**
 * Creates a new link for a specified site.
 */
public suspend inline fun NetworkManagerClient.createLink(crossinline block: CreateLinkRequest.Builder.() -> Unit): CreateLinkResponse = createLink(CreateLinkRequest.Builder().apply(block).build())

/**
 * Creates a new site in a global network.
 */
public suspend inline fun NetworkManagerClient.createSite(crossinline block: CreateSiteRequest.Builder.() -> Unit): CreateSiteResponse = createSite(CreateSiteRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
 */
public suspend inline fun NetworkManagerClient.createSiteToSiteVpnAttachment(crossinline block: CreateSiteToSiteVpnAttachmentRequest.Builder.() -> Unit): CreateSiteToSiteVpnAttachmentResponse = createSiteToSiteVpnAttachment(CreateSiteToSiteVpnAttachmentRequest.Builder().apply(block).build())

/**
 * Creates a transit gateway peering connection.
 */
public suspend inline fun NetworkManagerClient.createTransitGatewayPeering(crossinline block: CreateTransitGatewayPeeringRequest.Builder.() -> Unit): CreateTransitGatewayPeeringResponse = createTransitGatewayPeering(CreateTransitGatewayPeeringRequest.Builder().apply(block).build())

/**
 * Creates a transit gateway route table attachment.
 */
public suspend inline fun NetworkManagerClient.createTransitGatewayRouteTableAttachment(crossinline block: CreateTransitGatewayRouteTableAttachmentRequest.Builder.() -> Unit): CreateTransitGatewayRouteTableAttachmentResponse = createTransitGatewayRouteTableAttachment(CreateTransitGatewayRouteTableAttachmentRequest.Builder().apply(block).build())

/**
 * Creates a VPC attachment on an edge location of a core network.
 */
public suspend inline fun NetworkManagerClient.createVpcAttachment(crossinline block: CreateVpcAttachmentRequest.Builder.() -> Unit): CreateVpcAttachmentResponse = createVpcAttachment(CreateVpcAttachmentRequest.Builder().apply(block).build())

/**
 * Deletes an attachment. Supports all attachment types.
 */
public suspend inline fun NetworkManagerClient.deleteAttachment(crossinline block: DeleteAttachmentRequest.Builder.() -> Unit): DeleteAttachmentResponse = deleteAttachment(DeleteAttachmentRequest.Builder().apply(block).build())

/**
 * Deletes a Connect peer.
 */
public suspend inline fun NetworkManagerClient.deleteConnectPeer(crossinline block: DeleteConnectPeerRequest.Builder.() -> Unit): DeleteConnectPeerResponse = deleteConnectPeer(DeleteConnectPeerRequest.Builder().apply(block).build())

/**
 * Deletes the specified connection in your global network.
 */
public suspend inline fun NetworkManagerClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.
 */
public suspend inline fun NetworkManagerClient.deleteCoreNetwork(crossinline block: DeleteCoreNetworkRequest.Builder.() -> Unit): DeleteCoreNetworkResponse = deleteCoreNetwork(DeleteCoreNetworkRequest.Builder().apply(block).build())

/**
 * Deletes a policy version from a core network. You can't delete the current LIVE policy.
 */
public suspend inline fun NetworkManagerClient.deleteCoreNetworkPolicyVersion(crossinline block: DeleteCoreNetworkPolicyVersionRequest.Builder.() -> Unit): DeleteCoreNetworkPolicyVersionResponse = deleteCoreNetworkPolicyVersion(DeleteCoreNetworkPolicyVersionRequest.Builder().apply(block).build())

/**
 * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
 */
public suspend inline fun NetworkManagerClient.deleteDevice(crossinline block: DeleteDeviceRequest.Builder.() -> Unit): DeleteDeviceResponse = deleteDevice(DeleteDeviceRequest.Builder().apply(block).build())

/**
 * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites), deregister all transit gateways, and delete any core networks.
 */
public suspend inline fun NetworkManagerClient.deleteGlobalNetwork(crossinline block: DeleteGlobalNetworkRequest.Builder.() -> Unit): DeleteGlobalNetworkResponse = deleteGlobalNetwork(DeleteGlobalNetworkRequest.Builder().apply(block).build())

/**
 * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
 */
public suspend inline fun NetworkManagerClient.deleteLink(crossinline block: DeleteLinkRequest.Builder.() -> Unit): DeleteLinkResponse = deleteLink(DeleteLinkRequest.Builder().apply(block).build())

/**
 * Deletes an existing peering connection.
 */
public suspend inline fun NetworkManagerClient.deletePeering(crossinline block: DeletePeeringRequest.Builder.() -> Unit): DeletePeeringResponse = deletePeering(DeletePeeringRequest.Builder().apply(block).build())

/**
 * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.
 */
public suspend inline fun NetworkManagerClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes an existing site. The site cannot be associated with any device or link.
 */
public suspend inline fun NetworkManagerClient.deleteSite(crossinline block: DeleteSiteRequest.Builder.() -> Unit): DeleteSiteResponse = deleteSite(DeleteSiteRequest.Builder().apply(block).build())

/**
 * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
 */
public suspend inline fun NetworkManagerClient.deregisterTransitGateway(crossinline block: DeregisterTransitGatewayRequest.Builder.() -> Unit): DeregisterTransitGatewayResponse = deregisterTransitGateway(DeregisterTransitGatewayRequest.Builder().apply(block).build())

/**
 * Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate `Get*` action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.
 */
public suspend inline fun NetworkManagerClient.describeGlobalNetworks(crossinline block: DescribeGlobalNetworksRequest.Builder.() -> Unit): DescribeGlobalNetworksResponse = describeGlobalNetworks(DescribeGlobalNetworksRequest.Builder().apply(block).build())

/**
 * Disassociates a core network Connect peer from a device and a link.
 */
public suspend inline fun NetworkManagerClient.disassociateConnectPeer(crossinline block: DisassociateConnectPeerRequest.Builder.() -> Unit): DisassociateConnectPeerResponse = disassociateConnectPeer(DisassociateConnectPeerRequest.Builder().apply(block).build())

/**
 * Disassociates a customer gateway from a device and a link.
 */
public suspend inline fun NetworkManagerClient.disassociateCustomerGateway(crossinline block: DisassociateCustomerGatewayRequest.Builder.() -> Unit): DisassociateCustomerGatewayResponse = disassociateCustomerGateway(DisassociateCustomerGatewayRequest.Builder().apply(block).build())

/**
 * Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
 */
public suspend inline fun NetworkManagerClient.disassociateLink(crossinline block: DisassociateLinkRequest.Builder.() -> Unit): DisassociateLinkResponse = disassociateLink(DisassociateLinkRequest.Builder().apply(block).build())

/**
 * Disassociates a transit gateway Connect peer from a device and link.
 */
public suspend inline fun NetworkManagerClient.disassociateTransitGatewayConnectPeer(crossinline block: DisassociateTransitGatewayConnectPeerRequest.Builder.() -> Unit): DisassociateTransitGatewayConnectPeerResponse = disassociateTransitGatewayConnectPeer(DisassociateTransitGatewayConnectPeerRequest.Builder().apply(block).build())

/**
 * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
 */
public suspend inline fun NetworkManagerClient.executeCoreNetworkChangeSet(crossinline block: ExecuteCoreNetworkChangeSetRequest.Builder.() -> Unit): ExecuteCoreNetworkChangeSetResponse = executeCoreNetworkChangeSet(ExecuteCoreNetworkChangeSetRequest.Builder().apply(block).build())

/**
 * Returns information about a core network Connect attachment.
 */
public suspend inline fun NetworkManagerClient.getConnectAttachment(crossinline block: GetConnectAttachmentRequest.Builder.() -> Unit): GetConnectAttachmentResponse = getConnectAttachment(GetConnectAttachmentRequest.Builder().apply(block).build())

/**
 * Returns information about a core network Connect peer.
 */
public suspend inline fun NetworkManagerClient.getConnectPeer(crossinline block: GetConnectPeerRequest.Builder.() -> Unit): GetConnectPeerResponse = getConnectPeer(GetConnectPeerRequest.Builder().apply(block).build())

/**
 * Returns information about a core network Connect peer associations.
 */
public suspend inline fun NetworkManagerClient.getConnectPeerAssociations(crossinline block: GetConnectPeerAssociationsRequest.Builder.() -> Unit): GetConnectPeerAssociationsResponse = getConnectPeerAssociations(GetConnectPeerAssociationsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more of your connections in a global network.
 */
public suspend inline fun NetworkManagerClient.getConnections(crossinline block: GetConnectionsRequest.Builder.() -> Unit): GetConnectionsResponse = getConnections(GetConnectionsRequest.Builder().apply(block).build())

/**
 * Returns information about the LIVE policy for a core network.
 */
public suspend inline fun NetworkManagerClient.getCoreNetwork(crossinline block: GetCoreNetworkRequest.Builder.() -> Unit): GetCoreNetworkResponse = getCoreNetwork(GetCoreNetworkRequest.Builder().apply(block).build())

/**
 * Returns information about a core network change event.
 */
public suspend inline fun NetworkManagerClient.getCoreNetworkChangeEvents(crossinline block: GetCoreNetworkChangeEventsRequest.Builder.() -> Unit): GetCoreNetworkChangeEventsResponse = getCoreNetworkChangeEvents(GetCoreNetworkChangeEventsRequest.Builder().apply(block).build())

/**
 * Returns a change set between the LIVE core network policy and a submitted policy.
 */
public suspend inline fun NetworkManagerClient.getCoreNetworkChangeSet(crossinline block: GetCoreNetworkChangeSetRequest.Builder.() -> Unit): GetCoreNetworkChangeSetResponse = getCoreNetworkChangeSet(GetCoreNetworkChangeSetRequest.Builder().apply(block).build())

/**
 * Returns details about a core network policy. You can get details about your current live policy or any previous policy version.
 */
public suspend inline fun NetworkManagerClient.getCoreNetworkPolicy(crossinline block: GetCoreNetworkPolicyRequest.Builder.() -> Unit): GetCoreNetworkPolicyResponse = getCoreNetworkPolicy(GetCoreNetworkPolicyRequest.Builder().apply(block).build())

/**
 * Gets the association information for customer gateways that are associated with devices and links in your global network.
 */
public suspend inline fun NetworkManagerClient.getCustomerGatewayAssociations(crossinline block: GetCustomerGatewayAssociationsRequest.Builder.() -> Unit): GetCustomerGatewayAssociationsResponse = getCustomerGatewayAssociations(GetCustomerGatewayAssociationsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more of your devices in a global network.
 */
public suspend inline fun NetworkManagerClient.getDevices(crossinline block: GetDevicesRequest.Builder.() -> Unit): GetDevicesResponse = getDevices(GetDevicesRequest.Builder().apply(block).build())

/**
 * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
 */
public suspend inline fun NetworkManagerClient.getLinkAssociations(crossinline block: GetLinkAssociationsRequest.Builder.() -> Unit): GetLinkAssociationsResponse = getLinkAssociations(GetLinkAssociationsRequest.Builder().apply(block).build())

/**
 * Gets information about one or more links in a specified global network.
 *
 * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.
 */
public suspend inline fun NetworkManagerClient.getLinks(crossinline block: GetLinksRequest.Builder.() -> Unit): GetLinksResponse = getLinks(GetLinksRequest.Builder().apply(block).build())

/**
 * Gets the count of network resources, by resource type, for the specified global network.
 */
public suspend inline fun NetworkManagerClient.getNetworkResourceCounts(crossinline block: GetNetworkResourceCountsRequest.Builder.() -> Unit): GetNetworkResourceCountsResponse = getNetworkResourceCounts(GetNetworkResourceCountsRequest.Builder().apply(block).build())

/**
 * Gets the network resource relationships for the specified global network.
 */
public suspend inline fun NetworkManagerClient.getNetworkResourceRelationships(crossinline block: GetNetworkResourceRelationshipsRequest.Builder.() -> Unit): GetNetworkResourceRelationshipsResponse = getNetworkResourceRelationships(GetNetworkResourceRelationshipsRequest.Builder().apply(block).build())

/**
 * Describes the network resources for the specified global network.
 *
 * The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.
 */
public suspend inline fun NetworkManagerClient.getNetworkResources(crossinline block: GetNetworkResourcesRequest.Builder.() -> Unit): GetNetworkResourcesResponse = getNetworkResources(GetNetworkResourcesRequest.Builder().apply(block).build())

/**
 * Gets the network routes of the specified global network.
 */
public suspend inline fun NetworkManagerClient.getNetworkRoutes(crossinline block: GetNetworkRoutesRequest.Builder.() -> Unit): GetNetworkRoutesResponse = getNetworkRoutes(GetNetworkRoutesRequest.Builder().apply(block).build())

/**
 * Gets the network telemetry of the specified global network.
 */
public suspend inline fun NetworkManagerClient.getNetworkTelemetry(crossinline block: GetNetworkTelemetryRequest.Builder.() -> Unit): GetNetworkTelemetryResponse = getNetworkTelemetry(GetNetworkTelemetryRequest.Builder().apply(block).build())

/**
 * Returns information about a resource policy.
 */
public suspend inline fun NetworkManagerClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Gets information about the specified route analysis.
 */
public suspend inline fun NetworkManagerClient.getRouteAnalysis(crossinline block: GetRouteAnalysisRequest.Builder.() -> Unit): GetRouteAnalysisResponse = getRouteAnalysis(GetRouteAnalysisRequest.Builder().apply(block).build())

/**
 * Returns information about a site-to-site VPN attachment.
 */
public suspend inline fun NetworkManagerClient.getSiteToSiteVpnAttachment(crossinline block: GetSiteToSiteVpnAttachmentRequest.Builder.() -> Unit): GetSiteToSiteVpnAttachmentResponse = getSiteToSiteVpnAttachment(GetSiteToSiteVpnAttachmentRequest.Builder().apply(block).build())

/**
 * Gets information about one or more of your sites in a global network.
 */
public suspend inline fun NetworkManagerClient.getSites(crossinline block: GetSitesRequest.Builder.() -> Unit): GetSitesResponse = getSites(GetSitesRequest.Builder().apply(block).build())

/**
 * Gets information about one or more of your transit gateway Connect peer associations in a global network.
 */
public suspend inline fun NetworkManagerClient.getTransitGatewayConnectPeerAssociations(crossinline block: GetTransitGatewayConnectPeerAssociationsRequest.Builder.() -> Unit): GetTransitGatewayConnectPeerAssociationsResponse = getTransitGatewayConnectPeerAssociations(GetTransitGatewayConnectPeerAssociationsRequest.Builder().apply(block).build())

/**
 * Returns information about a transit gateway peer.
 */
public suspend inline fun NetworkManagerClient.getTransitGatewayPeering(crossinline block: GetTransitGatewayPeeringRequest.Builder.() -> Unit): GetTransitGatewayPeeringResponse = getTransitGatewayPeering(GetTransitGatewayPeeringRequest.Builder().apply(block).build())

/**
 * Gets information about the transit gateway registrations in a specified global network.
 */
public suspend inline fun NetworkManagerClient.getTransitGatewayRegistrations(crossinline block: GetTransitGatewayRegistrationsRequest.Builder.() -> Unit): GetTransitGatewayRegistrationsResponse = getTransitGatewayRegistrations(GetTransitGatewayRegistrationsRequest.Builder().apply(block).build())

/**
 * Returns information about a transit gateway route table attachment.
 */
public suspend inline fun NetworkManagerClient.getTransitGatewayRouteTableAttachment(crossinline block: GetTransitGatewayRouteTableAttachmentRequest.Builder.() -> Unit): GetTransitGatewayRouteTableAttachmentResponse = getTransitGatewayRouteTableAttachment(GetTransitGatewayRouteTableAttachmentRequest.Builder().apply(block).build())

/**
 * Returns information about a VPC attachment.
 */
public suspend inline fun NetworkManagerClient.getVpcAttachment(crossinline block: GetVpcAttachmentRequest.Builder.() -> Unit): GetVpcAttachmentResponse = getVpcAttachment(GetVpcAttachmentRequest.Builder().apply(block).build())

/**
 * Returns a list of core network attachments.
 */
public suspend inline fun NetworkManagerClient.listAttachments(crossinline block: ListAttachmentsRequest.Builder.() -> Unit): ListAttachmentsResponse = listAttachments(ListAttachmentsRequest.Builder().apply(block).build())

/**
 * Returns a list of core network Connect peers.
 */
public suspend inline fun NetworkManagerClient.listConnectPeers(crossinline block: ListConnectPeersRequest.Builder.() -> Unit): ListConnectPeersResponse = listConnectPeers(ListConnectPeersRequest.Builder().apply(block).build())

/**
 * Returns a list of core network policy versions.
 */
public suspend inline fun NetworkManagerClient.listCoreNetworkPolicyVersions(crossinline block: ListCoreNetworkPolicyVersionsRequest.Builder.() -> Unit): ListCoreNetworkPolicyVersionsResponse = listCoreNetworkPolicyVersions(ListCoreNetworkPolicyVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of owned and shared core networks.
 */
public suspend inline fun NetworkManagerClient.listCoreNetworks(crossinline block: ListCoreNetworksRequest.Builder.() -> Unit): ListCoreNetworksResponse = listCoreNetworks(ListCoreNetworksRequest.Builder().apply(block).build())

/**
 * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services Organization.
 */
public suspend inline fun NetworkManagerClient.listOrganizationServiceAccessStatus(crossinline block: ListOrganizationServiceAccessStatusRequest.Builder.() -> Unit): ListOrganizationServiceAccessStatusResponse = listOrganizationServiceAccessStatus(ListOrganizationServiceAccessStatusRequest.Builder().apply(block).build())

/**
 * Lists the peerings for a core network.
 */
public suspend inline fun NetworkManagerClient.listPeerings(crossinline block: ListPeeringsRequest.Builder.() -> Unit): ListPeeringsResponse = listPeerings(ListPeeringsRequest.Builder().apply(block).build())

/**
 * Lists the tags for a specified resource.
 */
public suspend inline fun NetworkManagerClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.
 */
public suspend inline fun NetworkManagerClient.putCoreNetworkPolicy(crossinline block: PutCoreNetworkPolicyRequest.Builder.() -> Unit): PutCoreNetworkPolicyResponse = putCoreNetworkPolicy(PutCoreNetworkPolicyRequest.Builder().apply(block).build())

/**
 * Creates or updates a resource policy.
 */
public suspend inline fun NetworkManagerClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Registers a transit gateway in your global network. The transit gateway can be in any Amazon Web Services Region, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.
 */
public suspend inline fun NetworkManagerClient.registerTransitGateway(crossinline block: RegisterTransitGatewayRequest.Builder.() -> Unit): RegisterTransitGatewayResponse = registerTransitGateway(RegisterTransitGatewayRequest.Builder().apply(block).build())

/**
 * Rejects a core network attachment request.
 */
public suspend inline fun NetworkManagerClient.rejectAttachment(crossinline block: RejectAttachmentRequest.Builder.() -> Unit): RejectAttachmentResponse = rejectAttachment(RejectAttachmentRequest.Builder().apply(block).build())

/**
 * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.
 */
public suspend inline fun NetworkManagerClient.restoreCoreNetworkPolicyVersion(crossinline block: RestoreCoreNetworkPolicyVersionRequest.Builder.() -> Unit): RestoreCoreNetworkPolicyVersionResponse = restoreCoreNetworkPolicyVersion(RestoreCoreNetworkPolicyVersionRequest.Builder().apply(block).build())

/**
 * Enables for the Network Manager service for an Amazon Web Services Organization. This can only be called by a management account within the organization.
 */
public suspend inline fun NetworkManagerClient.startOrganizationServiceAccessUpdate(crossinline block: StartOrganizationServiceAccessUpdateRequest.Builder.() -> Unit): StartOrganizationServiceAccessUpdateResponse = startOrganizationServiceAccessUpdate(StartOrganizationServiceAccessUpdateRequest.Builder().apply(block).build())

/**
 * Starts analyzing the routing path between the specified source and destination. For more information, see [Route Analyzer](https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html).
 */
public suspend inline fun NetworkManagerClient.startRouteAnalysis(crossinline block: StartRouteAnalysisRequest.Builder.() -> Unit): StartRouteAnalysisResponse = startRouteAnalysis(StartRouteAnalysisRequest.Builder().apply(block).build())

/**
 * Tags a specified resource.
 */
public suspend inline fun NetworkManagerClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a specified resource.
 */
public suspend inline fun NetworkManagerClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.
 */
public suspend inline fun NetworkManagerClient.updateConnection(crossinline block: UpdateConnectionRequest.Builder.() -> Unit): UpdateConnectionResponse = updateConnection(UpdateConnectionRequest.Builder().apply(block).build())

/**
 * Updates the description of a core network.
 */
public suspend inline fun NetworkManagerClient.updateCoreNetwork(crossinline block: UpdateCoreNetworkRequest.Builder.() -> Unit): UpdateCoreNetworkResponse = updateCoreNetwork(UpdateCoreNetworkRequest.Builder().apply(block).build())

/**
 * Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
 */
public suspend inline fun NetworkManagerClient.updateDevice(crossinline block: UpdateDeviceRequest.Builder.() -> Unit): UpdateDeviceResponse = updateDevice(UpdateDeviceRequest.Builder().apply(block).build())

/**
 * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
 */
public suspend inline fun NetworkManagerClient.updateGlobalNetwork(crossinline block: UpdateGlobalNetworkRequest.Builder.() -> Unit): UpdateGlobalNetworkResponse = updateGlobalNetwork(UpdateGlobalNetworkRequest.Builder().apply(block).build())

/**
 * Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
 */
public suspend inline fun NetworkManagerClient.updateLink(crossinline block: UpdateLinkRequest.Builder.() -> Unit): UpdateLinkResponse = updateLink(UpdateLinkRequest.Builder().apply(block).build())

/**
 * Updates the resource metadata for the specified global network.
 */
public suspend inline fun NetworkManagerClient.updateNetworkResourceMetadata(crossinline block: UpdateNetworkResourceMetadataRequest.Builder.() -> Unit): UpdateNetworkResourceMetadataResponse = updateNetworkResourceMetadata(UpdateNetworkResourceMetadataRequest.Builder().apply(block).build())

/**
 * Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
 */
public suspend inline fun NetworkManagerClient.updateSite(crossinline block: UpdateSiteRequest.Builder.() -> Unit): UpdateSiteResponse = updateSite(UpdateSiteRequest.Builder().apply(block).build())

/**
 * Updates a VPC attachment.
 */
public suspend inline fun NetworkManagerClient.updateVpcAttachment(crossinline block: UpdateVpcAttachmentRequest.Builder.() -> Unit): UpdateVpcAttachmentResponse = updateVpcAttachment(UpdateVpcAttachmentRequest.Builder().apply(block).build())
