// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.serde

import aws.sdk.kotlin.services.networkmanager.model.AwsLocation
import aws.sdk.kotlin.services.networkmanager.model.Location
import aws.sdk.kotlin.services.networkmanager.model.UpdateDeviceRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateDeviceOperationSerializer: HttpSerializer.NonStreaming<UpdateDeviceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateDeviceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.globalNetworkId) { "globalNetworkId is bound to the URI and must not be null" }
            requireNotNull(input.deviceId) { "deviceId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("global-networks"))
                add(PercentEncoding.SmithyLabel.encode(input.globalNetworkId))
                add(PercentEncoding.Path.encode("devices"))
                add(PercentEncoding.SmithyLabel.encode(input.deviceId))
            }
        }

        val payload = serializeUpdateDeviceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDeviceOperationBody(context: ExecutionContext, input: UpdateDeviceRequest): ByteArray {
    val serializer = JsonSerializer()
    val AWSLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AWSLocation"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Location"))
    val MODEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Model"))
    val SERIALNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SerialNumber"))
    val SITEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SiteId"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Type"))
    val VENDOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Vendor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AWSLOCATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LOCATION_DESCRIPTOR)
        field(MODEL_DESCRIPTOR)
        field(SERIALNUMBER_DESCRIPTOR)
        field(SITEID_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(VENDOR_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.awsLocation?.let { field(AWSLOCATION_DESCRIPTOR, it, ::serializeAwsLocationDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.location?.let { field(LOCATION_DESCRIPTOR, it, ::serializeLocationDocument) }
        input.model?.let { field(MODEL_DESCRIPTOR, it) }
        input.serialNumber?.let { field(SERIALNUMBER_DESCRIPTOR, it) }
        input.siteId?.let { field(SITEID_DESCRIPTOR, it) }
        input.type?.let { field(TYPE_DESCRIPTOR, it) }
        input.vendor?.let { field(VENDOR_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
