// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.serde

import aws.sdk.kotlin.services.networkmanager.model.UpdateConnectionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateConnectionOperationSerializer: HttpSerializer.NonStreaming<UpdateConnectionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateConnectionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.globalNetworkId) { "globalNetworkId is bound to the URI and must not be null" }
            requireNotNull(input.connectionId) { "connectionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("global-networks"))
                add(PercentEncoding.SmithyLabel.encode(input.globalNetworkId))
                add(PercentEncoding.Path.encode("connections"))
                add(PercentEncoding.SmithyLabel.encode(input.connectionId))
            }
        }

        val payload = serializeUpdateConnectionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateConnectionOperationBody(context: ExecutionContext, input: UpdateConnectionRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONNECTEDLINKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectedLinkId"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val LINKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LinkId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTEDLINKID_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LINKID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.connectedLinkId?.let { field(CONNECTEDLINKID_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.linkId?.let { field(LINKID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
