// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.serde

import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkSegmentEdgeIdentifier
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkRoutesResponse
import aws.sdk.kotlin.services.networkmanager.model.NetworkManagerException
import aws.sdk.kotlin.services.networkmanager.model.NetworkRoute
import aws.sdk.kotlin.services.networkmanager.model.RouteTableType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetNetworkRoutesOperationDeserializer: HttpDeserializer.NonStreaming<GetNetworkRoutesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetNetworkRoutesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetNetworkRoutesError(context, call, payload)
        }
        val builder = GetNetworkRoutesResponse.Builder()

        if (payload != null) {
            deserializeGetNetworkRoutesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetNetworkRoutesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkManagerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NetworkManagerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetNetworkRoutesOperationBody(builder: GetNetworkRoutesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CORENETWORKSEGMENTEDGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CoreNetworkSegmentEdge"))
    val NETWORKROUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NetworkRoutes"))
    val ROUTETABLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteTableArn"))
    val ROUTETABLETIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("RouteTableTimestamp"))
    val ROUTETABLETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("RouteTableType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CORENETWORKSEGMENTEDGE_DESCRIPTOR)
        field(NETWORKROUTES_DESCRIPTOR)
        field(ROUTETABLEARN_DESCRIPTOR)
        field(ROUTETABLETIMESTAMP_DESCRIPTOR)
        field(ROUTETABLETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CORENETWORKSEGMENTEDGE_DESCRIPTOR.index -> builder.coreNetworkSegmentEdge = deserializeCoreNetworkSegmentEdgeIdentifierDocument(deserializer)
                NETWORKROUTES_DESCRIPTOR.index -> builder.networkRoutes =
                    deserializer.deserializeList(NETWORKROUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<NetworkRoute>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeNetworkRouteDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROUTETABLEARN_DESCRIPTOR.index -> builder.routeTableArn = deserializeString()
                ROUTETABLETIMESTAMP_DESCRIPTOR.index -> builder.routeTableTimestamp = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ROUTETABLETYPE_DESCRIPTOR.index -> builder.routeTableType = deserializeString().let { RouteTableType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
