// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.serde

import aws.sdk.kotlin.services.networkmanager.model.BgpOptions
import aws.sdk.kotlin.services.networkmanager.model.CreateConnectPeerRequest
import aws.sdk.kotlin.services.networkmanager.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateConnectPeerOperationSerializer: HttpSerializer.NonStreaming<CreateConnectPeerRequest> {
    override fun serialize(context: ExecutionContext, input: CreateConnectPeerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/connect-peers"
        }

        val payload = serializeCreateConnectPeerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateConnectPeerOperationBody(context: ExecutionContext, input: CreateConnectPeerRequest): ByteArray {
    val serializer = JsonSerializer()
    val BGPOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BgpOptions"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val CONNECTATTACHMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ConnectAttachmentId"))
    val CORENETWORKADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CoreNetworkAddress"))
    val INSIDECIDRBLOCKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InsideCidrBlocks"))
    val PEERADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PeerAddress"))
    val SUBNETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubnetArn"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BGPOPTIONS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONNECTATTACHMENTID_DESCRIPTOR)
        field(CORENETWORKADDRESS_DESCRIPTOR)
        field(INSIDECIDRBLOCKS_DESCRIPTOR)
        field(PEERADDRESS_DESCRIPTOR)
        field(SUBNETARN_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.bgpOptions?.let { field(BGPOPTIONS_DESCRIPTOR, it, ::serializeBgpOptionsDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.connectAttachmentId?.let { field(CONNECTATTACHMENTID_DESCRIPTOR, it) }
        input.coreNetworkAddress?.let { field(CORENETWORKADDRESS_DESCRIPTOR, it) }
        if (input.insideCidrBlocks != null) {
            listField(INSIDECIDRBLOCKS_DESCRIPTOR) {
                for (el0 in input.insideCidrBlocks) {
                    serializeString(el0)
                }
            }
        }
        input.peerAddress?.let { field(PEERADDRESS_DESCRIPTOR, it) }
        input.subnetArn?.let { field(SUBNETARN_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
