// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.paginators

import aws.sdk.kotlin.services.networkmanager.NetworkManagerClient
import aws.sdk.kotlin.services.networkmanager.model.Attachment
import aws.sdk.kotlin.services.networkmanager.model.ConnectPeerAssociation
import aws.sdk.kotlin.services.networkmanager.model.ConnectPeerSummary
import aws.sdk.kotlin.services.networkmanager.model.Connection
import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChange
import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkChangeEvent
import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicyVersion
import aws.sdk.kotlin.services.networkmanager.model.CoreNetworkSummary
import aws.sdk.kotlin.services.networkmanager.model.CustomerGatewayAssociation
import aws.sdk.kotlin.services.networkmanager.model.DescribeGlobalNetworksRequest
import aws.sdk.kotlin.services.networkmanager.model.DescribeGlobalNetworksResponse
import aws.sdk.kotlin.services.networkmanager.model.Device
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectPeerAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetConnectionsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetConnectionsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeEventsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeEventsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeSetRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCoreNetworkChangeSetResponse
import aws.sdk.kotlin.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetCustomerGatewayAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetDevicesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetDevicesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetLinkAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetLinkAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetLinksRequest
import aws.sdk.kotlin.services.networkmanager.model.GetLinksResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceCountsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceCountsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceRelationshipsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourceRelationshipsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkResourcesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkTelemetryRequest
import aws.sdk.kotlin.services.networkmanager.model.GetNetworkTelemetryResponse
import aws.sdk.kotlin.services.networkmanager.model.GetSitesRequest
import aws.sdk.kotlin.services.networkmanager.model.GetSitesResponse
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRegistrationsRequest
import aws.sdk.kotlin.services.networkmanager.model.GetTransitGatewayRegistrationsResponse
import aws.sdk.kotlin.services.networkmanager.model.GlobalNetwork
import aws.sdk.kotlin.services.networkmanager.model.Link
import aws.sdk.kotlin.services.networkmanager.model.LinkAssociation
import aws.sdk.kotlin.services.networkmanager.model.ListAttachmentsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListAttachmentsResponse
import aws.sdk.kotlin.services.networkmanager.model.ListConnectPeersRequest
import aws.sdk.kotlin.services.networkmanager.model.ListConnectPeersResponse
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworksRequest
import aws.sdk.kotlin.services.networkmanager.model.ListCoreNetworksResponse
import aws.sdk.kotlin.services.networkmanager.model.ListPeeringsRequest
import aws.sdk.kotlin.services.networkmanager.model.ListPeeringsResponse
import aws.sdk.kotlin.services.networkmanager.model.NetworkResource
import aws.sdk.kotlin.services.networkmanager.model.NetworkResourceCount
import aws.sdk.kotlin.services.networkmanager.model.NetworkTelemetry
import aws.sdk.kotlin.services.networkmanager.model.Peering
import aws.sdk.kotlin.services.networkmanager.model.Relationship
import aws.sdk.kotlin.services.networkmanager.model.Site
import aws.sdk.kotlin.services.networkmanager.model.TransitGatewayConnectPeerAssociation
import aws.sdk.kotlin.services.networkmanager.model.TransitGatewayRegistration
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeGlobalNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeGlobalNetworksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalNetworksResponse]
 */
public fun NetworkManagerClient.describeGlobalNetworksPaginated(initialRequest: DescribeGlobalNetworksRequest = DescribeGlobalNetworksRequest { }): Flow<DescribeGlobalNetworksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeGlobalNetworksPaginated.describeGlobalNetworks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeGlobalNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeGlobalNetworksResponse]
 */
public fun NetworkManagerClient.describeGlobalNetworksPaginated(block: DescribeGlobalNetworksRequest.Builder.() -> Unit): Flow<DescribeGlobalNetworksResponse> =
    describeGlobalNetworksPaginated(DescribeGlobalNetworksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeGlobalNetworksPaginated]
 * to access the nested member [GlobalNetwork]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GlobalNetwork]
 */
@JvmName("describeGlobalNetworksResponseGlobalNetwork")
public fun Flow<DescribeGlobalNetworksResponse>.globalNetworks(): Flow<GlobalNetwork> =
    transform() { response ->
        response.globalNetworks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetConnectionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetConnectionsResponse]
 */
public fun NetworkManagerClient.getConnectionsPaginated(initialRequest: GetConnectionsRequest): Flow<GetConnectionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getConnectionsPaginated.getConnections(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetConnectionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetConnectionsResponse]
 */
public fun NetworkManagerClient.getConnectionsPaginated(block: GetConnectionsRequest.Builder.() -> Unit): Flow<GetConnectionsResponse> =
    getConnectionsPaginated(GetConnectionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getConnectionsPaginated]
 * to access the nested member [Connection]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Connection]
 */
@JvmName("getConnectionsResponseConnection")
public fun Flow<GetConnectionsResponse>.connections(): Flow<Connection> =
    transform() { response ->
        response.connections?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetConnectPeerAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetConnectPeerAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetConnectPeerAssociationsResponse]
 */
public fun NetworkManagerClient.getConnectPeerAssociationsPaginated(initialRequest: GetConnectPeerAssociationsRequest): Flow<GetConnectPeerAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getConnectPeerAssociationsPaginated.getConnectPeerAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetConnectPeerAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetConnectPeerAssociationsResponse]
 */
public fun NetworkManagerClient.getConnectPeerAssociationsPaginated(block: GetConnectPeerAssociationsRequest.Builder.() -> Unit): Flow<GetConnectPeerAssociationsResponse> =
    getConnectPeerAssociationsPaginated(GetConnectPeerAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getConnectPeerAssociationsPaginated]
 * to access the nested member [ConnectPeerAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConnectPeerAssociation]
 */
@JvmName("getConnectPeerAssociationsResponseConnectPeerAssociation")
public fun Flow<GetConnectPeerAssociationsResponse>.connectPeerAssociations(): Flow<ConnectPeerAssociation> =
    transform() { response ->
        response.connectPeerAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetCoreNetworkChangeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCoreNetworkChangeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCoreNetworkChangeEventsResponse]
 */
public fun NetworkManagerClient.getCoreNetworkChangeEventsPaginated(initialRequest: GetCoreNetworkChangeEventsRequest): Flow<GetCoreNetworkChangeEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCoreNetworkChangeEventsPaginated.getCoreNetworkChangeEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCoreNetworkChangeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCoreNetworkChangeEventsResponse]
 */
public fun NetworkManagerClient.getCoreNetworkChangeEventsPaginated(block: GetCoreNetworkChangeEventsRequest.Builder.() -> Unit): Flow<GetCoreNetworkChangeEventsResponse> =
    getCoreNetworkChangeEventsPaginated(GetCoreNetworkChangeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getCoreNetworkChangeEventsPaginated]
 * to access the nested member [CoreNetworkChangeEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoreNetworkChangeEvent]
 */
@JvmName("getCoreNetworkChangeEventsResponseCoreNetworkChangeEvent")
public fun Flow<GetCoreNetworkChangeEventsResponse>.coreNetworkChangeEvents(): Flow<CoreNetworkChangeEvent> =
    transform() { response ->
        response.coreNetworkChangeEvents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetCoreNetworkChangeSetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCoreNetworkChangeSetRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCoreNetworkChangeSetResponse]
 */
public fun NetworkManagerClient.getCoreNetworkChangeSetPaginated(initialRequest: GetCoreNetworkChangeSetRequest): Flow<GetCoreNetworkChangeSetResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCoreNetworkChangeSetPaginated.getCoreNetworkChangeSet(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCoreNetworkChangeSetResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCoreNetworkChangeSetResponse]
 */
public fun NetworkManagerClient.getCoreNetworkChangeSetPaginated(block: GetCoreNetworkChangeSetRequest.Builder.() -> Unit): Flow<GetCoreNetworkChangeSetResponse> =
    getCoreNetworkChangeSetPaginated(GetCoreNetworkChangeSetRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getCoreNetworkChangeSetPaginated]
 * to access the nested member [CoreNetworkChange]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoreNetworkChange]
 */
@JvmName("getCoreNetworkChangeSetResponseCoreNetworkChange")
public fun Flow<GetCoreNetworkChangeSetResponse>.coreNetworkChanges(): Flow<CoreNetworkChange> =
    transform() { response ->
        response.coreNetworkChanges?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetCustomerGatewayAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCustomerGatewayAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCustomerGatewayAssociationsResponse]
 */
public fun NetworkManagerClient.getCustomerGatewayAssociationsPaginated(initialRequest: GetCustomerGatewayAssociationsRequest): Flow<GetCustomerGatewayAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCustomerGatewayAssociationsPaginated.getCustomerGatewayAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCustomerGatewayAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCustomerGatewayAssociationsResponse]
 */
public fun NetworkManagerClient.getCustomerGatewayAssociationsPaginated(block: GetCustomerGatewayAssociationsRequest.Builder.() -> Unit): Flow<GetCustomerGatewayAssociationsResponse> =
    getCustomerGatewayAssociationsPaginated(GetCustomerGatewayAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getCustomerGatewayAssociationsPaginated]
 * to access the nested member [CustomerGatewayAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomerGatewayAssociation]
 */
@JvmName("getCustomerGatewayAssociationsResponseCustomerGatewayAssociation")
public fun Flow<GetCustomerGatewayAssociationsResponse>.customerGatewayAssociations(): Flow<CustomerGatewayAssociation> =
    transform() { response ->
        response.customerGatewayAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetDevicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDevicesResponse]
 */
public fun NetworkManagerClient.getDevicesPaginated(initialRequest: GetDevicesRequest): Flow<GetDevicesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getDevicesPaginated.getDevices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetDevicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetDevicesResponse]
 */
public fun NetworkManagerClient.getDevicesPaginated(block: GetDevicesRequest.Builder.() -> Unit): Flow<GetDevicesResponse> =
    getDevicesPaginated(GetDevicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getDevicesPaginated]
 * to access the nested member [Device]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Device]
 */
@JvmName("getDevicesResponseDevice")
public fun Flow<GetDevicesResponse>.devices(): Flow<Device> =
    transform() { response ->
        response.devices?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetLinkAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetLinkAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLinkAssociationsResponse]
 */
public fun NetworkManagerClient.getLinkAssociationsPaginated(initialRequest: GetLinkAssociationsRequest): Flow<GetLinkAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getLinkAssociationsPaginated.getLinkAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetLinkAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLinkAssociationsResponse]
 */
public fun NetworkManagerClient.getLinkAssociationsPaginated(block: GetLinkAssociationsRequest.Builder.() -> Unit): Flow<GetLinkAssociationsResponse> =
    getLinkAssociationsPaginated(GetLinkAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getLinkAssociationsPaginated]
 * to access the nested member [LinkAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LinkAssociation]
 */
@JvmName("getLinkAssociationsResponseLinkAssociation")
public fun Flow<GetLinkAssociationsResponse>.linkAssociations(): Flow<LinkAssociation> =
    transform() { response ->
        response.linkAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetLinksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLinksResponse]
 */
public fun NetworkManagerClient.getLinksPaginated(initialRequest: GetLinksRequest): Flow<GetLinksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getLinksPaginated.getLinks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetLinksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetLinksResponse]
 */
public fun NetworkManagerClient.getLinksPaginated(block: GetLinksRequest.Builder.() -> Unit): Flow<GetLinksResponse> =
    getLinksPaginated(GetLinksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getLinksPaginated]
 * to access the nested member [Link]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Link]
 */
@JvmName("getLinksResponseLink")
public fun Flow<GetLinksResponse>.links(): Flow<Link> =
    transform() { response ->
        response.links?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetNetworkResourceCountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetNetworkResourceCountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkResourceCountsResponse]
 */
public fun NetworkManagerClient.getNetworkResourceCountsPaginated(initialRequest: GetNetworkResourceCountsRequest): Flow<GetNetworkResourceCountsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getNetworkResourceCountsPaginated.getNetworkResourceCounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetNetworkResourceCountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkResourceCountsResponse]
 */
public fun NetworkManagerClient.getNetworkResourceCountsPaginated(block: GetNetworkResourceCountsRequest.Builder.() -> Unit): Flow<GetNetworkResourceCountsResponse> =
    getNetworkResourceCountsPaginated(GetNetworkResourceCountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getNetworkResourceCountsPaginated]
 * to access the nested member [NetworkResourceCount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NetworkResourceCount]
 */
@JvmName("getNetworkResourceCountsResponseNetworkResourceCount")
public fun Flow<GetNetworkResourceCountsResponse>.networkResourceCounts(): Flow<NetworkResourceCount> =
    transform() { response ->
        response.networkResourceCounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetNetworkResourceRelationshipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetNetworkResourceRelationshipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkResourceRelationshipsResponse]
 */
public fun NetworkManagerClient.getNetworkResourceRelationshipsPaginated(initialRequest: GetNetworkResourceRelationshipsRequest): Flow<GetNetworkResourceRelationshipsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getNetworkResourceRelationshipsPaginated.getNetworkResourceRelationships(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetNetworkResourceRelationshipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkResourceRelationshipsResponse]
 */
public fun NetworkManagerClient.getNetworkResourceRelationshipsPaginated(block: GetNetworkResourceRelationshipsRequest.Builder.() -> Unit): Flow<GetNetworkResourceRelationshipsResponse> =
    getNetworkResourceRelationshipsPaginated(GetNetworkResourceRelationshipsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getNetworkResourceRelationshipsPaginated]
 * to access the nested member [Relationship]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Relationship]
 */
@JvmName("getNetworkResourceRelationshipsResponseRelationship")
public fun Flow<GetNetworkResourceRelationshipsResponse>.relationships(): Flow<Relationship> =
    transform() { response ->
        response.relationships?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetNetworkResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetNetworkResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkResourcesResponse]
 */
public fun NetworkManagerClient.getNetworkResourcesPaginated(initialRequest: GetNetworkResourcesRequest): Flow<GetNetworkResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getNetworkResourcesPaginated.getNetworkResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetNetworkResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkResourcesResponse]
 */
public fun NetworkManagerClient.getNetworkResourcesPaginated(block: GetNetworkResourcesRequest.Builder.() -> Unit): Flow<GetNetworkResourcesResponse> =
    getNetworkResourcesPaginated(GetNetworkResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getNetworkResourcesPaginated]
 * to access the nested member [NetworkResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NetworkResource]
 */
@JvmName("getNetworkResourcesResponseNetworkResource")
public fun Flow<GetNetworkResourcesResponse>.networkResources(): Flow<NetworkResource> =
    transform() { response ->
        response.networkResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetNetworkTelemetryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetNetworkTelemetryRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkTelemetryResponse]
 */
public fun NetworkManagerClient.getNetworkTelemetryPaginated(initialRequest: GetNetworkTelemetryRequest): Flow<GetNetworkTelemetryResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getNetworkTelemetryPaginated.getNetworkTelemetry(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetNetworkTelemetryResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetNetworkTelemetryResponse]
 */
public fun NetworkManagerClient.getNetworkTelemetryPaginated(block: GetNetworkTelemetryRequest.Builder.() -> Unit): Flow<GetNetworkTelemetryResponse> =
    getNetworkTelemetryPaginated(GetNetworkTelemetryRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getNetworkTelemetryPaginated]
 * to access the nested member [NetworkTelemetry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NetworkTelemetry]
 */
@JvmName("getNetworkTelemetryResponseNetworkTelemetry")
public fun Flow<GetNetworkTelemetryResponse>.networkTelemetry(): Flow<NetworkTelemetry> =
    transform() { response ->
        response.networkTelemetry?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetSitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetSitesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSitesResponse]
 */
public fun NetworkManagerClient.getSitesPaginated(initialRequest: GetSitesRequest): Flow<GetSitesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getSitesPaginated.getSites(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetSitesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetSitesResponse]
 */
public fun NetworkManagerClient.getSitesPaginated(block: GetSitesRequest.Builder.() -> Unit): Flow<GetSitesResponse> =
    getSitesPaginated(GetSitesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getSitesPaginated]
 * to access the nested member [Site]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Site]
 */
@JvmName("getSitesResponseSite")
public fun Flow<GetSitesResponse>.sites(): Flow<Site> =
    transform() { response ->
        response.sites?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetTransitGatewayConnectPeerAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTransitGatewayConnectPeerAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTransitGatewayConnectPeerAssociationsResponse]
 */
public fun NetworkManagerClient.getTransitGatewayConnectPeerAssociationsPaginated(initialRequest: GetTransitGatewayConnectPeerAssociationsRequest): Flow<GetTransitGatewayConnectPeerAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTransitGatewayConnectPeerAssociationsPaginated.getTransitGatewayConnectPeerAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetTransitGatewayConnectPeerAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTransitGatewayConnectPeerAssociationsResponse]
 */
public fun NetworkManagerClient.getTransitGatewayConnectPeerAssociationsPaginated(block: GetTransitGatewayConnectPeerAssociationsRequest.Builder.() -> Unit): Flow<GetTransitGatewayConnectPeerAssociationsResponse> =
    getTransitGatewayConnectPeerAssociationsPaginated(GetTransitGatewayConnectPeerAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getTransitGatewayConnectPeerAssociationsPaginated]
 * to access the nested member [TransitGatewayConnectPeerAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransitGatewayConnectPeerAssociation]
 */
@JvmName("getTransitGatewayConnectPeerAssociationsResponseTransitGatewayConnectPeerAssociation")
public fun Flow<GetTransitGatewayConnectPeerAssociationsResponse>.transitGatewayConnectPeerAssociations(): Flow<TransitGatewayConnectPeerAssociation> =
    transform() { response ->
        response.transitGatewayConnectPeerAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [GetTransitGatewayRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetTransitGatewayRegistrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTransitGatewayRegistrationsResponse]
 */
public fun NetworkManagerClient.getTransitGatewayRegistrationsPaginated(initialRequest: GetTransitGatewayRegistrationsRequest): Flow<GetTransitGatewayRegistrationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getTransitGatewayRegistrationsPaginated.getTransitGatewayRegistrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetTransitGatewayRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetTransitGatewayRegistrationsResponse]
 */
public fun NetworkManagerClient.getTransitGatewayRegistrationsPaginated(block: GetTransitGatewayRegistrationsRequest.Builder.() -> Unit): Flow<GetTransitGatewayRegistrationsResponse> =
    getTransitGatewayRegistrationsPaginated(GetTransitGatewayRegistrationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getTransitGatewayRegistrationsPaginated]
 * to access the nested member [TransitGatewayRegistration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransitGatewayRegistration]
 */
@JvmName("getTransitGatewayRegistrationsResponseTransitGatewayRegistration")
public fun Flow<GetTransitGatewayRegistrationsResponse>.transitGatewayRegistrations(): Flow<TransitGatewayRegistration> =
    transform() { response ->
        response.transitGatewayRegistrations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAttachmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAttachmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachmentsResponse]
 */
public fun NetworkManagerClient.listAttachmentsPaginated(initialRequest: ListAttachmentsRequest = ListAttachmentsRequest { }): Flow<ListAttachmentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAttachmentsPaginated.listAttachments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAttachmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAttachmentsResponse]
 */
public fun NetworkManagerClient.listAttachmentsPaginated(block: ListAttachmentsRequest.Builder.() -> Unit): Flow<ListAttachmentsResponse> =
    listAttachmentsPaginated(ListAttachmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAttachmentsPaginated]
 * to access the nested member [Attachment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Attachment]
 */
@JvmName("listAttachmentsResponseAttachment")
public fun Flow<ListAttachmentsResponse>.attachments(): Flow<Attachment> =
    transform() { response ->
        response.attachments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConnectPeersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectPeersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectPeersResponse]
 */
public fun NetworkManagerClient.listConnectPeersPaginated(initialRequest: ListConnectPeersRequest = ListConnectPeersRequest { }): Flow<ListConnectPeersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectPeersPaginated.listConnectPeers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectPeersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectPeersResponse]
 */
public fun NetworkManagerClient.listConnectPeersPaginated(block: ListConnectPeersRequest.Builder.() -> Unit): Flow<ListConnectPeersResponse> =
    listConnectPeersPaginated(ListConnectPeersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConnectPeersPaginated]
 * to access the nested member [ConnectPeerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ConnectPeerSummary]
 */
@JvmName("listConnectPeersResponseConnectPeerSummary")
public fun Flow<ListConnectPeersResponse>.connectPeers(): Flow<ConnectPeerSummary> =
    transform() { response ->
        response.connectPeers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoreNetworkPolicyVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoreNetworkPolicyVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoreNetworkPolicyVersionsResponse]
 */
public fun NetworkManagerClient.listCoreNetworkPolicyVersionsPaginated(initialRequest: ListCoreNetworkPolicyVersionsRequest): Flow<ListCoreNetworkPolicyVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoreNetworkPolicyVersionsPaginated.listCoreNetworkPolicyVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoreNetworkPolicyVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoreNetworkPolicyVersionsResponse]
 */
public fun NetworkManagerClient.listCoreNetworkPolicyVersionsPaginated(block: ListCoreNetworkPolicyVersionsRequest.Builder.() -> Unit): Flow<ListCoreNetworkPolicyVersionsResponse> =
    listCoreNetworkPolicyVersionsPaginated(ListCoreNetworkPolicyVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoreNetworkPolicyVersionsPaginated]
 * to access the nested member [CoreNetworkPolicyVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoreNetworkPolicyVersion]
 */
@JvmName("listCoreNetworkPolicyVersionsResponseCoreNetworkPolicyVersion")
public fun Flow<ListCoreNetworkPolicyVersionsResponse>.coreNetworkPolicyVersions(): Flow<CoreNetworkPolicyVersion> =
    transform() { response ->
        response.coreNetworkPolicyVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoreNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoreNetworksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoreNetworksResponse]
 */
public fun NetworkManagerClient.listCoreNetworksPaginated(initialRequest: ListCoreNetworksRequest = ListCoreNetworksRequest { }): Flow<ListCoreNetworksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoreNetworksPaginated.listCoreNetworks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoreNetworksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoreNetworksResponse]
 */
public fun NetworkManagerClient.listCoreNetworksPaginated(block: ListCoreNetworksRequest.Builder.() -> Unit): Flow<ListCoreNetworksResponse> =
    listCoreNetworksPaginated(ListCoreNetworksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoreNetworksPaginated]
 * to access the nested member [CoreNetworkSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoreNetworkSummary]
 */
@JvmName("listCoreNetworksResponseCoreNetworkSummary")
public fun Flow<ListCoreNetworksResponse>.coreNetworks(): Flow<CoreNetworkSummary> =
    transform() { response ->
        response.coreNetworks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPeeringsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPeeringsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPeeringsResponse]
 */
public fun NetworkManagerClient.listPeeringsPaginated(initialRequest: ListPeeringsRequest = ListPeeringsRequest { }): Flow<ListPeeringsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPeeringsPaginated.listPeerings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPeeringsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPeeringsResponse]
 */
public fun NetworkManagerClient.listPeeringsPaginated(block: ListPeeringsRequest.Builder.() -> Unit): Flow<ListPeeringsResponse> =
    listPeeringsPaginated(ListPeeringsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPeeringsPaginated]
 * to access the nested member [Peering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Peering]
 */
@JvmName("listPeeringsResponsePeering")
public fun Flow<ListPeeringsResponse>.peerings(): Flow<Peering> =
    transform() { response ->
        response.peerings?.forEach {
            emit(it)
        }
    }
