// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the action that the service insertion will take for any segments associated with it.
 */
public class ServiceInsertionAction private constructor(builder: Builder) {
    /**
     * The action the service insertion takes for traffic. `send-via` sends east-west traffic between attachments. `send-to` sends north-south traffic to the security appliance, and then from that to either the Internet or to an on-premesis location.
     */
    public val action: aws.sdk.kotlin.services.networkmanager.model.SegmentActionServiceInsertion? = builder.action
    /**
     * Describes the mode packets take for the `send-via` action. This is not used when the action is `send-to`. `dual-hop` packets traverse attachments in both the source to the destination core network edges. This mode requires that an inspection attachment must be present in all Regions of the service insertion-enabled segments. For `single-hop`, packets traverse a single intermediate inserted attachment. You can use `EdgeOverride` to specify a specific edge to use.
     */
    public val mode: aws.sdk.kotlin.services.networkmanager.model.SendViaMode? = builder.mode
    /**
     * The list of network function groups and any edge overrides for the chosen service insertion action. Used for both `send-to` or `send-via`.
     */
    public val via: aws.sdk.kotlin.services.networkmanager.model.Via? = builder.via
    /**
     * The list of destination segments if the service insertion action is `send-via`.
     */
    public val whenSentTo: aws.sdk.kotlin.services.networkmanager.model.WhenSentTo? = builder.whenSentTo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.ServiceInsertionAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceInsertionAction(")
        append("action=$action,")
        append("mode=$mode,")
        append("via=$via,")
        append("whenSentTo=$whenSentTo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (via?.hashCode() ?: 0)
        result = 31 * result + (whenSentTo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceInsertionAction

        if (action != other.action) return false
        if (mode != other.mode) return false
        if (via != other.via) return false
        if (whenSentTo != other.whenSentTo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.ServiceInsertionAction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action the service insertion takes for traffic. `send-via` sends east-west traffic between attachments. `send-to` sends north-south traffic to the security appliance, and then from that to either the Internet or to an on-premesis location.
         */
        public var action: aws.sdk.kotlin.services.networkmanager.model.SegmentActionServiceInsertion? = null
        /**
         * Describes the mode packets take for the `send-via` action. This is not used when the action is `send-to`. `dual-hop` packets traverse attachments in both the source to the destination core network edges. This mode requires that an inspection attachment must be present in all Regions of the service insertion-enabled segments. For `single-hop`, packets traverse a single intermediate inserted attachment. You can use `EdgeOverride` to specify a specific edge to use.
         */
        public var mode: aws.sdk.kotlin.services.networkmanager.model.SendViaMode? = null
        /**
         * The list of network function groups and any edge overrides for the chosen service insertion action. Used for both `send-to` or `send-via`.
         */
        public var via: aws.sdk.kotlin.services.networkmanager.model.Via? = null
        /**
         * The list of destination segments if the service insertion action is `send-via`.
         */
        public var whenSentTo: aws.sdk.kotlin.services.networkmanager.model.WhenSentTo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.ServiceInsertionAction) : this() {
            this.action = x.action
            this.mode = x.mode
            this.via = x.via
            this.whenSentTo = x.whenSentTo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.ServiceInsertionAction = ServiceInsertionAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkmanager.model.Via] inside the given [block]
         */
        public fun via(block: aws.sdk.kotlin.services.networkmanager.model.Via.Builder.() -> kotlin.Unit) {
            this.via = aws.sdk.kotlin.services.networkmanager.model.Via.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkmanager.model.WhenSentTo] inside the given [block]
         */
        public fun whenSentTo(block: aws.sdk.kotlin.services.networkmanager.model.WhenSentTo.Builder.() -> kotlin.Unit) {
            this.whenSentTo = aws.sdk.kotlin.services.networkmanager.model.WhenSentTo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
