// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The status of an Amazon Web Services Organization and the accounts within that organization.
 */
public class OrganizationStatus private constructor(builder: Builder) {
    /**
     * The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's accounts. This will be either `SUCCEEDED` or `IN_PROGRESS`.
     */
    public val accountStatusList: List<AccountStatus>? = builder.accountStatusList
    /**
     * The status of the organization's AWS service access. This will be `ENABLED` or `DISABLED`.
     */
    public val organizationAwsServiceAccessStatus: kotlin.String? = builder.organizationAwsServiceAccessStatus
    /**
     * The ID of an Amazon Web Services Organization.
     */
    public val organizationId: kotlin.String? = builder.organizationId
    /**
     * The status of the SLR deployment for the account. This will be either `SUCCEEDED` or `IN_PROGRESS`.
     */
    public val slrDeploymentStatus: kotlin.String? = builder.slrDeploymentStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.OrganizationStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OrganizationStatus(")
        append("accountStatusList=$accountStatusList,")
        append("organizationAwsServiceAccessStatus=$organizationAwsServiceAccessStatus,")
        append("organizationId=$organizationId,")
        append("slrDeploymentStatus=$slrDeploymentStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountStatusList?.hashCode() ?: 0
        result = 31 * result + (organizationAwsServiceAccessStatus?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (slrDeploymentStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OrganizationStatus

        if (accountStatusList != other.accountStatusList) return false
        if (organizationAwsServiceAccessStatus != other.organizationAwsServiceAccessStatus) return false
        if (organizationId != other.organizationId) return false
        if (slrDeploymentStatus != other.slrDeploymentStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.OrganizationStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The current service-linked role (SLR) deployment status for an Amazon Web Services Organization's accounts. This will be either `SUCCEEDED` or `IN_PROGRESS`.
         */
        public var accountStatusList: List<AccountStatus>? = null
        /**
         * The status of the organization's AWS service access. This will be `ENABLED` or `DISABLED`.
         */
        public var organizationAwsServiceAccessStatus: kotlin.String? = null
        /**
         * The ID of an Amazon Web Services Organization.
         */
        public var organizationId: kotlin.String? = null
        /**
         * The status of the SLR deployment for the account. This will be either `SUCCEEDED` or `IN_PROGRESS`.
         */
        public var slrDeploymentStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.OrganizationStatus) : this() {
            this.accountStatusList = x.accountStatusList
            this.organizationAwsServiceAccessStatus = x.organizationAwsServiceAccessStatus
            this.organizationId = x.organizationId
            this.slrDeploymentStatus = x.slrDeploymentStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.OrganizationStatus = OrganizationStatus(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
