// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a core network policy. You can have only one LIVE Core Policy.
 */
public class CoreNetworkPolicy private constructor(builder: Builder) {
    /**
     * Whether a core network policy is the current LIVE policy or the most recently submitted policy.
     */
    public val alias: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicyAlias? = builder.alias
    /**
     * The state of a core network policy.
     */
    public val changeSetState: aws.sdk.kotlin.services.networkmanager.model.ChangeSetState? = builder.changeSetState
    /**
     * The ID of a core network.
     */
    public val coreNetworkId: kotlin.String? = builder.coreNetworkId
    /**
     * The timestamp when a core network policy was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of a core network policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Describes a core network policy.
     */
    public val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * Describes any errors in a core network policy.
     */
    public val policyErrors: List<CoreNetworkPolicyError>? = builder.policyErrors
    /**
     * The ID of the policy version.
     */
    public val policyVersionId: kotlin.Int? = builder.policyVersionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoreNetworkPolicy(")
        append("alias=$alias,")
        append("changeSetState=$changeSetState,")
        append("coreNetworkId=$coreNetworkId,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("policyDocument=$policyDocument,")
        append("policyErrors=$policyErrors,")
        append("policyVersionId=$policyVersionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alias?.hashCode() ?: 0
        result = 31 * result + (changeSetState?.hashCode() ?: 0)
        result = 31 * result + (coreNetworkId?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (policyErrors?.hashCode() ?: 0)
        result = 31 * result + (policyVersionId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoreNetworkPolicy

        if (alias != other.alias) return false
        if (changeSetState != other.changeSetState) return false
        if (coreNetworkId != other.coreNetworkId) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (policyDocument != other.policyDocument) return false
        if (policyErrors != other.policyErrors) return false
        if (policyVersionId != other.policyVersionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Whether a core network policy is the current LIVE policy or the most recently submitted policy.
         */
        public var alias: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicyAlias? = null
        /**
         * The state of a core network policy.
         */
        public var changeSetState: aws.sdk.kotlin.services.networkmanager.model.ChangeSetState? = null
        /**
         * The ID of a core network.
         */
        public var coreNetworkId: kotlin.String? = null
        /**
         * The timestamp when a core network policy was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of a core network policy.
         */
        public var description: kotlin.String? = null
        /**
         * Describes a core network policy.
         */
        public var policyDocument: kotlin.String? = null
        /**
         * Describes any errors in a core network policy.
         */
        public var policyErrors: List<CoreNetworkPolicyError>? = null
        /**
         * The ID of the policy version.
         */
        public var policyVersionId: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicy) : this() {
            this.alias = x.alias
            this.changeSetState = x.changeSetState
            this.coreNetworkId = x.coreNetworkId
            this.createdAt = x.createdAt
            this.description = x.description
            this.policyDocument = x.policyDocument
            this.policyErrors = x.policyErrors
            this.policyVersionId = x.policyVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkmanager.model.CoreNetworkPolicy = CoreNetworkPolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
