// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkmanager

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.networkmanager.auth.NetworkManagerAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.networkmanager.auth.NetworkManagerIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.networkmanager.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.networkmanager.model.*
import aws.sdk.kotlin.services.networkmanager.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultNetworkManagerClient(override val config: NetworkManagerClient.Config) : NetworkManagerClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = NetworkManagerIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "networkmanager")
        }
        toMap()
    }
    private val authSchemeAdapter = NetworkManagerAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.networkmanager"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Accepts a core network attachment request.
     *
     * Once the attachment request is accepted by a core network owner, the attachment is created and connected to a core network.
     */
    override suspend fun acceptAttachment(input: AcceptAttachmentRequest): AcceptAttachmentResponse {
        val op = SdkHttpOperation.build<AcceptAttachmentRequest, AcceptAttachmentResponse> {
            serializeWith = AcceptAttachmentOperationSerializer()
            deserializeWith = AcceptAttachmentOperationDeserializer()
            operationName = "AcceptAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a core network Connect peer with a device and optionally, with a link.
     *
     * If you specify a link, it must be associated with the specified device. You can only associate core network Connect peers that have been created on a core network Connect attachment on a core network.
     */
    override suspend fun associateConnectPeer(input: AssociateConnectPeerRequest): AssociateConnectPeerResponse {
        val op = SdkHttpOperation.build<AssociateConnectPeerRequest, AssociateConnectPeerResponse> {
            serializeWith = AssociateConnectPeerOperationSerializer()
            deserializeWith = AssociateConnectPeerOperationDeserializer()
            operationName = "AssociateConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a customer gateway with a device and optionally, with a link. If you specify a link, it must be associated with the specified device.
     *
     * You can only associate customer gateways that are connected to a VPN attachment on a transit gateway or core network registered in your global network. When you register a transit gateway or core network, customer gateways that are connected to the transit gateway are automatically included in the global network. To list customer gateways that are connected to a transit gateway, use the [DescribeVpnConnections](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpnConnections.html) EC2 API and filter by `transit-gateway-id`.
     *
     * You cannot associate a customer gateway with more than one device and link.
     */
    override suspend fun associateCustomerGateway(input: AssociateCustomerGatewayRequest): AssociateCustomerGatewayResponse {
        val op = SdkHttpOperation.build<AssociateCustomerGatewayRequest, AssociateCustomerGatewayResponse> {
            serializeWith = AssociateCustomerGatewayOperationSerializer()
            deserializeWith = AssociateCustomerGatewayOperationDeserializer()
            operationName = "AssociateCustomerGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a link to a device. A device can be associated to multiple links and a link can be associated to multiple devices. The device and link must be in the same global network and the same site.
     */
    override suspend fun associateLink(input: AssociateLinkRequest): AssociateLinkResponse {
        val op = SdkHttpOperation.build<AssociateLinkRequest, AssociateLinkResponse> {
            serializeWith = AssociateLinkOperationSerializer()
            deserializeWith = AssociateLinkOperationDeserializer()
            operationName = "AssociateLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a transit gateway Connect peer with a device, and optionally, with a link. If you specify a link, it must be associated with the specified device.
     *
     * You can only associate transit gateway Connect peers that have been created on a transit gateway that's registered in your global network.
     *
     * You cannot associate a transit gateway Connect peer with more than one device and link.
     */
    override suspend fun associateTransitGatewayConnectPeer(input: AssociateTransitGatewayConnectPeerRequest): AssociateTransitGatewayConnectPeerResponse {
        val op = SdkHttpOperation.build<AssociateTransitGatewayConnectPeerRequest, AssociateTransitGatewayConnectPeerResponse> {
            serializeWith = AssociateTransitGatewayConnectPeerOperationSerializer()
            deserializeWith = AssociateTransitGatewayConnectPeerOperationDeserializer()
            operationName = "AssociateTransitGatewayConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a core network Connect attachment from a specified core network attachment.
     *
     * A core network Connect attachment is a GRE-based tunnel attachment that you can use to establish a connection between a core network and an appliance. A core network Connect attachment uses an existing VPC attachment as the underlying transport mechanism.
     */
    override suspend fun createConnectAttachment(input: CreateConnectAttachmentRequest): CreateConnectAttachmentResponse {
        val op = SdkHttpOperation.build<CreateConnectAttachmentRequest, CreateConnectAttachmentResponse> {
            serializeWith = CreateConnectAttachmentOperationSerializer()
            deserializeWith = CreateConnectAttachmentOperationDeserializer()
            operationName = "CreateConnectAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).
     */
    override suspend fun createConnectPeer(input: CreateConnectPeerRequest): CreateConnectPeerResponse {
        val op = SdkHttpOperation.build<CreateConnectPeerRequest, CreateConnectPeerResponse> {
            serializeWith = CreateConnectPeerOperationSerializer()
            deserializeWith = CreateConnectPeerOperationDeserializer()
            operationName = "CreateConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a connection between two devices. The devices can be a physical or virtual appliance that connects to a third-party appliance in a VPC, or a physical appliance that connects to another physical appliance in an on-premises network.
     */
    override suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse {
        val op = SdkHttpOperation.build<CreateConnectionRequest, CreateConnectionResponse> {
            serializeWith = CreateConnectionOperationSerializer()
            deserializeWith = CreateConnectionOperationDeserializer()
            operationName = "CreateConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a core network as part of your global network, and optionally, with a core network policy.
     */
    override suspend fun createCoreNetwork(input: CreateCoreNetworkRequest): CreateCoreNetworkResponse {
        val op = SdkHttpOperation.build<CreateCoreNetworkRequest, CreateCoreNetworkResponse> {
            serializeWith = CreateCoreNetworkOperationSerializer()
            deserializeWith = CreateCoreNetworkOperationDeserializer()
            operationName = "CreateCoreNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new device in a global network. If you specify both a site ID and a location, the location of the site is used for visualization in the Network Manager console.
     */
    override suspend fun createDevice(input: CreateDeviceRequest): CreateDeviceResponse {
        val op = SdkHttpOperation.build<CreateDeviceRequest, CreateDeviceResponse> {
            serializeWith = CreateDeviceOperationSerializer()
            deserializeWith = CreateDeviceOperationDeserializer()
            operationName = "CreateDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new, empty global network.
     */
    override suspend fun createGlobalNetwork(input: CreateGlobalNetworkRequest): CreateGlobalNetworkResponse {
        val op = SdkHttpOperation.build<CreateGlobalNetworkRequest, CreateGlobalNetworkResponse> {
            serializeWith = CreateGlobalNetworkOperationSerializer()
            deserializeWith = CreateGlobalNetworkOperationDeserializer()
            operationName = "CreateGlobalNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new link for a specified site.
     */
    override suspend fun createLink(input: CreateLinkRequest): CreateLinkResponse {
        val op = SdkHttpOperation.build<CreateLinkRequest, CreateLinkResponse> {
            serializeWith = CreateLinkOperationSerializer()
            deserializeWith = CreateLinkOperationDeserializer()
            operationName = "CreateLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new site in a global network.
     */
    override suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse {
        val op = SdkHttpOperation.build<CreateSiteRequest, CreateSiteResponse> {
            serializeWith = CreateSiteOperationSerializer()
            deserializeWith = CreateSiteOperationDeserializer()
            operationName = "CreateSite"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core network.
     */
    override suspend fun createSiteToSiteVpnAttachment(input: CreateSiteToSiteVpnAttachmentRequest): CreateSiteToSiteVpnAttachmentResponse {
        val op = SdkHttpOperation.build<CreateSiteToSiteVpnAttachmentRequest, CreateSiteToSiteVpnAttachmentResponse> {
            serializeWith = CreateSiteToSiteVpnAttachmentOperationSerializer()
            deserializeWith = CreateSiteToSiteVpnAttachmentOperationDeserializer()
            operationName = "CreateSiteToSiteVpnAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a transit gateway peering connection.
     */
    override suspend fun createTransitGatewayPeering(input: CreateTransitGatewayPeeringRequest): CreateTransitGatewayPeeringResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayPeeringRequest, CreateTransitGatewayPeeringResponse> {
            serializeWith = CreateTransitGatewayPeeringOperationSerializer()
            deserializeWith = CreateTransitGatewayPeeringOperationDeserializer()
            operationName = "CreateTransitGatewayPeering"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a transit gateway route table attachment.
     */
    override suspend fun createTransitGatewayRouteTableAttachment(input: CreateTransitGatewayRouteTableAttachmentRequest): CreateTransitGatewayRouteTableAttachmentResponse {
        val op = SdkHttpOperation.build<CreateTransitGatewayRouteTableAttachmentRequest, CreateTransitGatewayRouteTableAttachmentResponse> {
            serializeWith = CreateTransitGatewayRouteTableAttachmentOperationSerializer()
            deserializeWith = CreateTransitGatewayRouteTableAttachmentOperationDeserializer()
            operationName = "CreateTransitGatewayRouteTableAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a VPC attachment on an edge location of a core network.
     */
    override suspend fun createVpcAttachment(input: CreateVpcAttachmentRequest): CreateVpcAttachmentResponse {
        val op = SdkHttpOperation.build<CreateVpcAttachmentRequest, CreateVpcAttachmentResponse> {
            serializeWith = CreateVpcAttachmentOperationSerializer()
            deserializeWith = CreateVpcAttachmentOperationDeserializer()
            operationName = "CreateVpcAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an attachment. Supports all attachment types.
     */
    override suspend fun deleteAttachment(input: DeleteAttachmentRequest): DeleteAttachmentResponse {
        val op = SdkHttpOperation.build<DeleteAttachmentRequest, DeleteAttachmentResponse> {
            serializeWith = DeleteAttachmentOperationSerializer()
            deserializeWith = DeleteAttachmentOperationDeserializer()
            operationName = "DeleteAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Connect peer.
     */
    override suspend fun deleteConnectPeer(input: DeleteConnectPeerRequest): DeleteConnectPeerResponse {
        val op = SdkHttpOperation.build<DeleteConnectPeerRequest, DeleteConnectPeerResponse> {
            serializeWith = DeleteConnectPeerOperationSerializer()
            deserializeWith = DeleteConnectPeerOperationDeserializer()
            operationName = "DeleteConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified connection in your global network.
     */
    override suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse {
        val op = SdkHttpOperation.build<DeleteConnectionRequest, DeleteConnectionResponse> {
            serializeWith = DeleteConnectionOperationSerializer()
            deserializeWith = DeleteConnectionOperationDeserializer()
            operationName = "DeleteConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a core network along with all core network policies. This can only be done if there are no attachments on a core network.
     */
    override suspend fun deleteCoreNetwork(input: DeleteCoreNetworkRequest): DeleteCoreNetworkResponse {
        val op = SdkHttpOperation.build<DeleteCoreNetworkRequest, DeleteCoreNetworkResponse> {
            serializeWith = DeleteCoreNetworkOperationSerializer()
            deserializeWith = DeleteCoreNetworkOperationDeserializer()
            operationName = "DeleteCoreNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a policy version from a core network. You can't delete the current LIVE policy.
     */
    override suspend fun deleteCoreNetworkPolicyVersion(input: DeleteCoreNetworkPolicyVersionRequest): DeleteCoreNetworkPolicyVersionResponse {
        val op = SdkHttpOperation.build<DeleteCoreNetworkPolicyVersionRequest, DeleteCoreNetworkPolicyVersionResponse> {
            serializeWith = DeleteCoreNetworkPolicyVersionOperationSerializer()
            deserializeWith = DeleteCoreNetworkPolicyVersionOperationDeserializer()
            operationName = "DeleteCoreNetworkPolicyVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing device. You must first disassociate the device from any links and customer gateways.
     */
    override suspend fun deleteDevice(input: DeleteDeviceRequest): DeleteDeviceResponse {
        val op = SdkHttpOperation.build<DeleteDeviceRequest, DeleteDeviceResponse> {
            serializeWith = DeleteDeviceOperationSerializer()
            deserializeWith = DeleteDeviceOperationDeserializer()
            operationName = "DeleteDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing global network. You must first delete all global network objects (devices, links, and sites), deregister all transit gateways, and delete any core networks.
     */
    override suspend fun deleteGlobalNetwork(input: DeleteGlobalNetworkRequest): DeleteGlobalNetworkResponse {
        val op = SdkHttpOperation.build<DeleteGlobalNetworkRequest, DeleteGlobalNetworkResponse> {
            serializeWith = DeleteGlobalNetworkOperationSerializer()
            deserializeWith = DeleteGlobalNetworkOperationDeserializer()
            operationName = "DeleteGlobalNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing link. You must first disassociate the link from any devices and customer gateways.
     */
    override suspend fun deleteLink(input: DeleteLinkRequest): DeleteLinkResponse {
        val op = SdkHttpOperation.build<DeleteLinkRequest, DeleteLinkResponse> {
            serializeWith = DeleteLinkOperationSerializer()
            deserializeWith = DeleteLinkOperationDeserializer()
            operationName = "DeleteLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing peering connection.
     */
    override suspend fun deletePeering(input: DeletePeeringRequest): DeletePeeringResponse {
        val op = SdkHttpOperation.build<DeletePeeringRequest, DeletePeeringResponse> {
            serializeWith = DeletePeeringOperationSerializer()
            deserializeWith = DeletePeeringOperationDeserializer()
            operationName = "DeletePeering"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a resource policy for the specified resource. This revokes the access of the principals specified in the resource policy.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializeWith = DeleteResourcePolicyOperationSerializer()
            deserializeWith = DeleteResourcePolicyOperationDeserializer()
            operationName = "DeleteResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing site. The site cannot be associated with any device or link.
     */
    override suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse {
        val op = SdkHttpOperation.build<DeleteSiteRequest, DeleteSiteResponse> {
            serializeWith = DeleteSiteOperationSerializer()
            deserializeWith = DeleteSiteOperationDeserializer()
            operationName = "DeleteSite"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters a transit gateway from your global network. This action does not delete your transit gateway, or modify any of its attachments. This action removes any customer gateway associations.
     */
    override suspend fun deregisterTransitGateway(input: DeregisterTransitGatewayRequest): DeregisterTransitGatewayResponse {
        val op = SdkHttpOperation.build<DeregisterTransitGatewayRequest, DeregisterTransitGatewayResponse> {
            serializeWith = DeregisterTransitGatewayOperationSerializer()
            deserializeWith = DeregisterTransitGatewayOperationDeserializer()
            operationName = "DeregisterTransitGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes one or more global networks. By default, all global networks are described. To describe the objects in your global network, you must use the appropriate `Get*` action. For example, to list the transit gateways in your global network, use GetTransitGatewayRegistrations.
     */
    override suspend fun describeGlobalNetworks(input: DescribeGlobalNetworksRequest): DescribeGlobalNetworksResponse {
        val op = SdkHttpOperation.build<DescribeGlobalNetworksRequest, DescribeGlobalNetworksResponse> {
            serializeWith = DescribeGlobalNetworksOperationSerializer()
            deserializeWith = DescribeGlobalNetworksOperationDeserializer()
            operationName = "DescribeGlobalNetworks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a core network Connect peer from a device and a link.
     */
    override suspend fun disassociateConnectPeer(input: DisassociateConnectPeerRequest): DisassociateConnectPeerResponse {
        val op = SdkHttpOperation.build<DisassociateConnectPeerRequest, DisassociateConnectPeerResponse> {
            serializeWith = DisassociateConnectPeerOperationSerializer()
            deserializeWith = DisassociateConnectPeerOperationDeserializer()
            operationName = "DisassociateConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a customer gateway from a device and a link.
     */
    override suspend fun disassociateCustomerGateway(input: DisassociateCustomerGatewayRequest): DisassociateCustomerGatewayResponse {
        val op = SdkHttpOperation.build<DisassociateCustomerGatewayRequest, DisassociateCustomerGatewayResponse> {
            serializeWith = DisassociateCustomerGatewayOperationSerializer()
            deserializeWith = DisassociateCustomerGatewayOperationDeserializer()
            operationName = "DisassociateCustomerGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates an existing device from a link. You must first disassociate any customer gateways that are associated with the link.
     */
    override suspend fun disassociateLink(input: DisassociateLinkRequest): DisassociateLinkResponse {
        val op = SdkHttpOperation.build<DisassociateLinkRequest, DisassociateLinkResponse> {
            serializeWith = DisassociateLinkOperationSerializer()
            deserializeWith = DisassociateLinkOperationDeserializer()
            operationName = "DisassociateLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a transit gateway Connect peer from a device and link.
     */
    override suspend fun disassociateTransitGatewayConnectPeer(input: DisassociateTransitGatewayConnectPeerRequest): DisassociateTransitGatewayConnectPeerResponse {
        val op = SdkHttpOperation.build<DisassociateTransitGatewayConnectPeerRequest, DisassociateTransitGatewayConnectPeerResponse> {
            serializeWith = DisassociateTransitGatewayConnectPeerOperationSerializer()
            deserializeWith = DisassociateTransitGatewayConnectPeerOperationDeserializer()
            operationName = "DisassociateTransitGatewayConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Executes a change set on your core network. Deploys changes globally based on the policy submitted..
     */
    override suspend fun executeCoreNetworkChangeSet(input: ExecuteCoreNetworkChangeSetRequest): ExecuteCoreNetworkChangeSetResponse {
        val op = SdkHttpOperation.build<ExecuteCoreNetworkChangeSetRequest, ExecuteCoreNetworkChangeSetResponse> {
            serializeWith = ExecuteCoreNetworkChangeSetOperationSerializer()
            deserializeWith = ExecuteCoreNetworkChangeSetOperationDeserializer()
            operationName = "ExecuteCoreNetworkChangeSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a core network Connect attachment.
     */
    override suspend fun getConnectAttachment(input: GetConnectAttachmentRequest): GetConnectAttachmentResponse {
        val op = SdkHttpOperation.build<GetConnectAttachmentRequest, GetConnectAttachmentResponse> {
            serializeWith = GetConnectAttachmentOperationSerializer()
            deserializeWith = GetConnectAttachmentOperationDeserializer()
            operationName = "GetConnectAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a core network Connect peer.
     */
    override suspend fun getConnectPeer(input: GetConnectPeerRequest): GetConnectPeerResponse {
        val op = SdkHttpOperation.build<GetConnectPeerRequest, GetConnectPeerResponse> {
            serializeWith = GetConnectPeerOperationSerializer()
            deserializeWith = GetConnectPeerOperationDeserializer()
            operationName = "GetConnectPeer"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a core network Connect peer associations.
     */
    override suspend fun getConnectPeerAssociations(input: GetConnectPeerAssociationsRequest): GetConnectPeerAssociationsResponse {
        val op = SdkHttpOperation.build<GetConnectPeerAssociationsRequest, GetConnectPeerAssociationsResponse> {
            serializeWith = GetConnectPeerAssociationsOperationSerializer()
            deserializeWith = GetConnectPeerAssociationsOperationDeserializer()
            operationName = "GetConnectPeerAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more of your connections in a global network.
     */
    override suspend fun getConnections(input: GetConnectionsRequest): GetConnectionsResponse {
        val op = SdkHttpOperation.build<GetConnectionsRequest, GetConnectionsResponse> {
            serializeWith = GetConnectionsOperationSerializer()
            deserializeWith = GetConnectionsOperationDeserializer()
            operationName = "GetConnections"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the LIVE policy for a core network.
     */
    override suspend fun getCoreNetwork(input: GetCoreNetworkRequest): GetCoreNetworkResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkRequest, GetCoreNetworkResponse> {
            serializeWith = GetCoreNetworkOperationSerializer()
            deserializeWith = GetCoreNetworkOperationDeserializer()
            operationName = "GetCoreNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a core network change event.
     */
    override suspend fun getCoreNetworkChangeEvents(input: GetCoreNetworkChangeEventsRequest): GetCoreNetworkChangeEventsResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkChangeEventsRequest, GetCoreNetworkChangeEventsResponse> {
            serializeWith = GetCoreNetworkChangeEventsOperationSerializer()
            deserializeWith = GetCoreNetworkChangeEventsOperationDeserializer()
            operationName = "GetCoreNetworkChangeEvents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a change set between the LIVE core network policy and a submitted policy.
     */
    override suspend fun getCoreNetworkChangeSet(input: GetCoreNetworkChangeSetRequest): GetCoreNetworkChangeSetResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkChangeSetRequest, GetCoreNetworkChangeSetResponse> {
            serializeWith = GetCoreNetworkChangeSetOperationSerializer()
            deserializeWith = GetCoreNetworkChangeSetOperationDeserializer()
            operationName = "GetCoreNetworkChangeSet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns details about a core network policy. You can get details about your current live policy or any previous policy version.
     */
    override suspend fun getCoreNetworkPolicy(input: GetCoreNetworkPolicyRequest): GetCoreNetworkPolicyResponse {
        val op = SdkHttpOperation.build<GetCoreNetworkPolicyRequest, GetCoreNetworkPolicyResponse> {
            serializeWith = GetCoreNetworkPolicyOperationSerializer()
            deserializeWith = GetCoreNetworkPolicyOperationDeserializer()
            operationName = "GetCoreNetworkPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the association information for customer gateways that are associated with devices and links in your global network.
     */
    override suspend fun getCustomerGatewayAssociations(input: GetCustomerGatewayAssociationsRequest): GetCustomerGatewayAssociationsResponse {
        val op = SdkHttpOperation.build<GetCustomerGatewayAssociationsRequest, GetCustomerGatewayAssociationsResponse> {
            serializeWith = GetCustomerGatewayAssociationsOperationSerializer()
            deserializeWith = GetCustomerGatewayAssociationsOperationDeserializer()
            operationName = "GetCustomerGatewayAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more of your devices in a global network.
     */
    override suspend fun getDevices(input: GetDevicesRequest): GetDevicesResponse {
        val op = SdkHttpOperation.build<GetDevicesRequest, GetDevicesResponse> {
            serializeWith = GetDevicesOperationSerializer()
            deserializeWith = GetDevicesOperationDeserializer()
            operationName = "GetDevices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the link associations for a device or a link. Either the device ID or the link ID must be specified.
     */
    override suspend fun getLinkAssociations(input: GetLinkAssociationsRequest): GetLinkAssociationsResponse {
        val op = SdkHttpOperation.build<GetLinkAssociationsRequest, GetLinkAssociationsResponse> {
            serializeWith = GetLinkAssociationsOperationSerializer()
            deserializeWith = GetLinkAssociationsOperationDeserializer()
            operationName = "GetLinkAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more links in a specified global network.
     *
     * If you specify the site ID, you cannot specify the type or provider in the same request. You can specify the type and provider in the same request.
     */
    override suspend fun getLinks(input: GetLinksRequest): GetLinksResponse {
        val op = SdkHttpOperation.build<GetLinksRequest, GetLinksResponse> {
            serializeWith = GetLinksOperationSerializer()
            deserializeWith = GetLinksOperationDeserializer()
            operationName = "GetLinks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the count of network resources, by resource type, for the specified global network.
     */
    override suspend fun getNetworkResourceCounts(input: GetNetworkResourceCountsRequest): GetNetworkResourceCountsResponse {
        val op = SdkHttpOperation.build<GetNetworkResourceCountsRequest, GetNetworkResourceCountsResponse> {
            serializeWith = GetNetworkResourceCountsOperationSerializer()
            deserializeWith = GetNetworkResourceCountsOperationDeserializer()
            operationName = "GetNetworkResourceCounts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network resource relationships for the specified global network.
     */
    override suspend fun getNetworkResourceRelationships(input: GetNetworkResourceRelationshipsRequest): GetNetworkResourceRelationshipsResponse {
        val op = SdkHttpOperation.build<GetNetworkResourceRelationshipsRequest, GetNetworkResourceRelationshipsResponse> {
            serializeWith = GetNetworkResourceRelationshipsOperationSerializer()
            deserializeWith = GetNetworkResourceRelationshipsOperationDeserializer()
            operationName = "GetNetworkResourceRelationships"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the network resources for the specified global network.
     *
     * The results include information from the corresponding Describe call for the resource, minus any sensitive information such as pre-shared keys.
     */
    override suspend fun getNetworkResources(input: GetNetworkResourcesRequest): GetNetworkResourcesResponse {
        val op = SdkHttpOperation.build<GetNetworkResourcesRequest, GetNetworkResourcesResponse> {
            serializeWith = GetNetworkResourcesOperationSerializer()
            deserializeWith = GetNetworkResourcesOperationDeserializer()
            operationName = "GetNetworkResources"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network routes of the specified global network.
     */
    override suspend fun getNetworkRoutes(input: GetNetworkRoutesRequest): GetNetworkRoutesResponse {
        val op = SdkHttpOperation.build<GetNetworkRoutesRequest, GetNetworkRoutesResponse> {
            serializeWith = GetNetworkRoutesOperationSerializer()
            deserializeWith = GetNetworkRoutesOperationDeserializer()
            operationName = "GetNetworkRoutes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the network telemetry of the specified global network.
     */
    override suspend fun getNetworkTelemetry(input: GetNetworkTelemetryRequest): GetNetworkTelemetryResponse {
        val op = SdkHttpOperation.build<GetNetworkTelemetryRequest, GetNetworkTelemetryResponse> {
            serializeWith = GetNetworkTelemetryOperationSerializer()
            deserializeWith = GetNetworkTelemetryOperationDeserializer()
            operationName = "GetNetworkTelemetry"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a resource policy.
     */
    override suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse {
        val op = SdkHttpOperation.build<GetResourcePolicyRequest, GetResourcePolicyResponse> {
            serializeWith = GetResourcePolicyOperationSerializer()
            deserializeWith = GetResourcePolicyOperationDeserializer()
            operationName = "GetResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified route analysis.
     */
    override suspend fun getRouteAnalysis(input: GetRouteAnalysisRequest): GetRouteAnalysisResponse {
        val op = SdkHttpOperation.build<GetRouteAnalysisRequest, GetRouteAnalysisResponse> {
            serializeWith = GetRouteAnalysisOperationSerializer()
            deserializeWith = GetRouteAnalysisOperationDeserializer()
            operationName = "GetRouteAnalysis"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a site-to-site VPN attachment.
     */
    override suspend fun getSiteToSiteVpnAttachment(input: GetSiteToSiteVpnAttachmentRequest): GetSiteToSiteVpnAttachmentResponse {
        val op = SdkHttpOperation.build<GetSiteToSiteVpnAttachmentRequest, GetSiteToSiteVpnAttachmentResponse> {
            serializeWith = GetSiteToSiteVpnAttachmentOperationSerializer()
            deserializeWith = GetSiteToSiteVpnAttachmentOperationDeserializer()
            operationName = "GetSiteToSiteVpnAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more of your sites in a global network.
     */
    override suspend fun getSites(input: GetSitesRequest): GetSitesResponse {
        val op = SdkHttpOperation.build<GetSitesRequest, GetSitesResponse> {
            serializeWith = GetSitesOperationSerializer()
            deserializeWith = GetSitesOperationDeserializer()
            operationName = "GetSites"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about one or more of your transit gateway Connect peer associations in a global network.
     */
    override suspend fun getTransitGatewayConnectPeerAssociations(input: GetTransitGatewayConnectPeerAssociationsRequest): GetTransitGatewayConnectPeerAssociationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayConnectPeerAssociationsRequest, GetTransitGatewayConnectPeerAssociationsResponse> {
            serializeWith = GetTransitGatewayConnectPeerAssociationsOperationSerializer()
            deserializeWith = GetTransitGatewayConnectPeerAssociationsOperationDeserializer()
            operationName = "GetTransitGatewayConnectPeerAssociations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a transit gateway peer.
     */
    override suspend fun getTransitGatewayPeering(input: GetTransitGatewayPeeringRequest): GetTransitGatewayPeeringResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayPeeringRequest, GetTransitGatewayPeeringResponse> {
            serializeWith = GetTransitGatewayPeeringOperationSerializer()
            deserializeWith = GetTransitGatewayPeeringOperationDeserializer()
            operationName = "GetTransitGatewayPeering"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the transit gateway registrations in a specified global network.
     */
    override suspend fun getTransitGatewayRegistrations(input: GetTransitGatewayRegistrationsRequest): GetTransitGatewayRegistrationsResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayRegistrationsRequest, GetTransitGatewayRegistrationsResponse> {
            serializeWith = GetTransitGatewayRegistrationsOperationSerializer()
            deserializeWith = GetTransitGatewayRegistrationsOperationDeserializer()
            operationName = "GetTransitGatewayRegistrations"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a transit gateway route table attachment.
     */
    override suspend fun getTransitGatewayRouteTableAttachment(input: GetTransitGatewayRouteTableAttachmentRequest): GetTransitGatewayRouteTableAttachmentResponse {
        val op = SdkHttpOperation.build<GetTransitGatewayRouteTableAttachmentRequest, GetTransitGatewayRouteTableAttachmentResponse> {
            serializeWith = GetTransitGatewayRouteTableAttachmentOperationSerializer()
            deserializeWith = GetTransitGatewayRouteTableAttachmentOperationDeserializer()
            operationName = "GetTransitGatewayRouteTableAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a VPC attachment.
     */
    override suspend fun getVpcAttachment(input: GetVpcAttachmentRequest): GetVpcAttachmentResponse {
        val op = SdkHttpOperation.build<GetVpcAttachmentRequest, GetVpcAttachmentResponse> {
            serializeWith = GetVpcAttachmentOperationSerializer()
            deserializeWith = GetVpcAttachmentOperationDeserializer()
            operationName = "GetVpcAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of core network attachments.
     */
    override suspend fun listAttachments(input: ListAttachmentsRequest): ListAttachmentsResponse {
        val op = SdkHttpOperation.build<ListAttachmentsRequest, ListAttachmentsResponse> {
            serializeWith = ListAttachmentsOperationSerializer()
            deserializeWith = ListAttachmentsOperationDeserializer()
            operationName = "ListAttachments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of core network Connect peers.
     */
    override suspend fun listConnectPeers(input: ListConnectPeersRequest): ListConnectPeersResponse {
        val op = SdkHttpOperation.build<ListConnectPeersRequest, ListConnectPeersResponse> {
            serializeWith = ListConnectPeersOperationSerializer()
            deserializeWith = ListConnectPeersOperationDeserializer()
            operationName = "ListConnectPeers"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of core network policy versions.
     */
    override suspend fun listCoreNetworkPolicyVersions(input: ListCoreNetworkPolicyVersionsRequest): ListCoreNetworkPolicyVersionsResponse {
        val op = SdkHttpOperation.build<ListCoreNetworkPolicyVersionsRequest, ListCoreNetworkPolicyVersionsResponse> {
            serializeWith = ListCoreNetworkPolicyVersionsOperationSerializer()
            deserializeWith = ListCoreNetworkPolicyVersionsOperationDeserializer()
            operationName = "ListCoreNetworkPolicyVersions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of owned and shared core networks.
     */
    override suspend fun listCoreNetworks(input: ListCoreNetworksRequest): ListCoreNetworksResponse {
        val op = SdkHttpOperation.build<ListCoreNetworksRequest, ListCoreNetworksResponse> {
            serializeWith = ListCoreNetworksOperationSerializer()
            deserializeWith = ListCoreNetworksOperationDeserializer()
            operationName = "ListCoreNetworks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given Amazon Web Services Organization.
     */
    override suspend fun listOrganizationServiceAccessStatus(input: ListOrganizationServiceAccessStatusRequest): ListOrganizationServiceAccessStatusResponse {
        val op = SdkHttpOperation.build<ListOrganizationServiceAccessStatusRequest, ListOrganizationServiceAccessStatusResponse> {
            serializeWith = ListOrganizationServiceAccessStatusOperationSerializer()
            deserializeWith = ListOrganizationServiceAccessStatusOperationDeserializer()
            operationName = "ListOrganizationServiceAccessStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the peerings for a core network.
     */
    override suspend fun listPeerings(input: ListPeeringsRequest): ListPeeringsResponse {
        val op = SdkHttpOperation.build<ListPeeringsRequest, ListPeeringsResponse> {
            serializeWith = ListPeeringsOperationSerializer()
            deserializeWith = ListPeeringsOperationDeserializer()
            operationName = "ListPeerings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for a specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and the submitted policy.
     */
    override suspend fun putCoreNetworkPolicy(input: PutCoreNetworkPolicyRequest): PutCoreNetworkPolicyResponse {
        val op = SdkHttpOperation.build<PutCoreNetworkPolicyRequest, PutCoreNetworkPolicyResponse> {
            serializeWith = PutCoreNetworkPolicyOperationSerializer()
            deserializeWith = PutCoreNetworkPolicyOperationDeserializer()
            operationName = "PutCoreNetworkPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates a resource policy.
     */
    override suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse {
        val op = SdkHttpOperation.build<PutResourcePolicyRequest, PutResourcePolicyResponse> {
            serializeWith = PutResourcePolicyOperationSerializer()
            deserializeWith = PutResourcePolicyOperationDeserializer()
            operationName = "PutResourcePolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers a transit gateway in your global network. Not all Regions support transit gateways for global networks. For a list of the supported Regions, see [Region Availability](https://docs.aws.amazon.com/network-manager/latest/tgwnm/what-are-global-networks.html#nm-available-regions) in the *Amazon Web Services Transit Gateways for Global Networks User Guide*. The transit gateway can be in any of the supported Amazon Web Services Regions, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.
     */
    override suspend fun registerTransitGateway(input: RegisterTransitGatewayRequest): RegisterTransitGatewayResponse {
        val op = SdkHttpOperation.build<RegisterTransitGatewayRequest, RegisterTransitGatewayResponse> {
            serializeWith = RegisterTransitGatewayOperationSerializer()
            deserializeWith = RegisterTransitGatewayOperationDeserializer()
            operationName = "RegisterTransitGateway"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rejects a core network attachment request.
     */
    override suspend fun rejectAttachment(input: RejectAttachmentRequest): RejectAttachmentResponse {
        val op = SdkHttpOperation.build<RejectAttachmentRequest, RejectAttachmentResponse> {
            serializeWith = RejectAttachmentOperationSerializer()
            deserializeWith = RejectAttachmentOperationDeserializer()
            operationName = "RejectAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Restores a previous policy version as a new, immutable version of a core network policy. A subsequent change set is created showing the differences between the LIVE policy and restored policy.
     */
    override suspend fun restoreCoreNetworkPolicyVersion(input: RestoreCoreNetworkPolicyVersionRequest): RestoreCoreNetworkPolicyVersionResponse {
        val op = SdkHttpOperation.build<RestoreCoreNetworkPolicyVersionRequest, RestoreCoreNetworkPolicyVersionResponse> {
            serializeWith = RestoreCoreNetworkPolicyVersionOperationSerializer()
            deserializeWith = RestoreCoreNetworkPolicyVersionOperationDeserializer()
            operationName = "RestoreCoreNetworkPolicyVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the Network Manager service for an Amazon Web Services Organization. This can only be called by a management account within the organization.
     */
    override suspend fun startOrganizationServiceAccessUpdate(input: StartOrganizationServiceAccessUpdateRequest): StartOrganizationServiceAccessUpdateResponse {
        val op = SdkHttpOperation.build<StartOrganizationServiceAccessUpdateRequest, StartOrganizationServiceAccessUpdateResponse> {
            serializeWith = StartOrganizationServiceAccessUpdateOperationSerializer()
            deserializeWith = StartOrganizationServiceAccessUpdateOperationDeserializer()
            operationName = "StartOrganizationServiceAccessUpdate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts analyzing the routing path between the specified source and destination. For more information, see [Route Analyzer](https://docs.aws.amazon.com/vpc/latest/tgw/route-analyzer.html).
     */
    override suspend fun startRouteAnalysis(input: StartRouteAnalysisRequest): StartRouteAnalysisResponse {
        val op = SdkHttpOperation.build<StartRouteAnalysisRequest, StartRouteAnalysisResponse> {
            serializeWith = StartRouteAnalysisOperationSerializer()
            deserializeWith = StartRouteAnalysisOperationDeserializer()
            operationName = "StartRouteAnalysis"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Tags a specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the information for an existing connection. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateConnection(input: UpdateConnectionRequest): UpdateConnectionResponse {
        val op = SdkHttpOperation.build<UpdateConnectionRequest, UpdateConnectionResponse> {
            serializeWith = UpdateConnectionOperationSerializer()
            deserializeWith = UpdateConnectionOperationDeserializer()
            operationName = "UpdateConnection"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the description of a core network.
     */
    override suspend fun updateCoreNetwork(input: UpdateCoreNetworkRequest): UpdateCoreNetworkResponse {
        val op = SdkHttpOperation.build<UpdateCoreNetworkRequest, UpdateCoreNetworkResponse> {
            serializeWith = UpdateCoreNetworkOperationSerializer()
            deserializeWith = UpdateCoreNetworkOperationDeserializer()
            operationName = "UpdateCoreNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details for an existing device. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateDevice(input: UpdateDeviceRequest): UpdateDeviceResponse {
        val op = SdkHttpOperation.build<UpdateDeviceRequest, UpdateDeviceResponse> {
            serializeWith = UpdateDeviceOperationSerializer()
            deserializeWith = UpdateDeviceOperationDeserializer()
            operationName = "UpdateDevice"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing global network. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateGlobalNetwork(input: UpdateGlobalNetworkRequest): UpdateGlobalNetworkResponse {
        val op = SdkHttpOperation.build<UpdateGlobalNetworkRequest, UpdateGlobalNetworkResponse> {
            serializeWith = UpdateGlobalNetworkOperationSerializer()
            deserializeWith = UpdateGlobalNetworkOperationDeserializer()
            operationName = "UpdateGlobalNetwork"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the details for an existing link. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateLink(input: UpdateLinkRequest): UpdateLinkResponse {
        val op = SdkHttpOperation.build<UpdateLinkRequest, UpdateLinkResponse> {
            serializeWith = UpdateLinkOperationSerializer()
            deserializeWith = UpdateLinkOperationDeserializer()
            operationName = "UpdateLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the resource metadata for the specified global network.
     */
    override suspend fun updateNetworkResourceMetadata(input: UpdateNetworkResourceMetadataRequest): UpdateNetworkResourceMetadataResponse {
        val op = SdkHttpOperation.build<UpdateNetworkResourceMetadataRequest, UpdateNetworkResourceMetadataResponse> {
            serializeWith = UpdateNetworkResourceMetadataOperationSerializer()
            deserializeWith = UpdateNetworkResourceMetadataOperationDeserializer()
            operationName = "UpdateNetworkResourceMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.
     */
    override suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse {
        val op = SdkHttpOperation.build<UpdateSiteRequest, UpdateSiteResponse> {
            serializeWith = UpdateSiteOperationSerializer()
            deserializeWith = UpdateSiteOperationDeserializer()
            operationName = "UpdateSite"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a VPC attachment.
     */
    override suspend fun updateVpcAttachment(input: UpdateVpcAttachmentRequest): UpdateVpcAttachmentResponse {
        val op = SdkHttpOperation.build<UpdateVpcAttachmentRequest, UpdateVpcAttachmentResponse> {
            serializeWith = UpdateVpcAttachmentOperationSerializer()
            deserializeWith = UpdateVpcAttachmentOperationDeserializer()
            operationName = "UpdateVpcAttachment"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "networkmanager")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
