// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A single Suricata rules specification, for use in a stateful rule group. Use this option to specify a simple Suricata rule with protocol, source and destination, ports, direction, and rule options. For information about the Suricata `Rules` format, see [Rules Format](https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html).
 */
public class StatefulRule private constructor(builder: Builder) {
    /**
     * Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow.
     *
     * The actions for a stateful rule are defined as follows:
     * + **PASS** - Permits the packets to go to the intended destination.
     * + **DROP** - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the FirewallLoggingConfiguration.
     * + **ALERT** - Sends an alert log message, if alert logging is configured in the FirewallLoggingConfiguration. You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with `ALERT` action, verify in the logs that the rule is filtering as you want, then change the action to `DROP`.
     * + **REJECT** - Drops traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and an RST bit contained in the TCP header flags. REJECT is available only for TCP traffic. This option doesn't support FTP or IMAP protocols.
     */
    public val action: aws.sdk.kotlin.services.networkfirewall.model.StatefulAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The stateful inspection criteria for this rule, used to inspect traffic flows.
     */
    public val header: aws.sdk.kotlin.services.networkfirewall.model.Header? = builder.header
    /**
     * Additional options for the rule. These are the Suricata `RuleOptions` settings.
     */
    public val ruleOptions: List<RuleOption> = requireNotNull(builder.ruleOptions) { "A non-null value must be provided for ruleOptions" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.StatefulRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatefulRule(")
        append("action=$action,")
        append("header=$header,")
        append("ruleOptions=$ruleOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (header?.hashCode() ?: 0)
        result = 31 * result + (ruleOptions.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatefulRule

        if (action != other.action) return false
        if (header != other.header) return false
        if (ruleOptions != other.ruleOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.StatefulRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines what Network Firewall should do with the packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow.
         *
         * The actions for a stateful rule are defined as follows:
         * + **PASS** - Permits the packets to go to the intended destination.
         * + **DROP** - Blocks the packets from going to the intended destination and sends an alert log message, if alert logging is configured in the FirewallLoggingConfiguration.
         * + **ALERT** - Sends an alert log message, if alert logging is configured in the FirewallLoggingConfiguration. You can use this action to test a rule that you intend to use to drop traffic. You can enable the rule with `ALERT` action, verify in the logs that the rule is filtering as you want, then change the action to `DROP`.
         * + **REJECT** - Drops traffic that matches the conditions of the stateful rule, and sends a TCP reset packet back to sender of the packet. A TCP reset packet is a packet with no payload and an RST bit contained in the TCP header flags. REJECT is available only for TCP traffic. This option doesn't support FTP or IMAP protocols.
         */
        public var action: aws.sdk.kotlin.services.networkfirewall.model.StatefulAction? = null
        /**
         * The stateful inspection criteria for this rule, used to inspect traffic flows.
         */
        public var header: aws.sdk.kotlin.services.networkfirewall.model.Header? = null
        /**
         * Additional options for the rule. These are the Suricata `RuleOptions` settings.
         */
        public var ruleOptions: List<RuleOption>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.StatefulRule) : this() {
            this.action = x.action
            this.header = x.header
            this.ruleOptions = x.ruleOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.StatefulRule = StatefulRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.Header] inside the given [block]
         */
        public fun header(block: aws.sdk.kotlin.services.networkfirewall.model.Header.Builder.() -> kotlin.Unit) {
            this.header = aws.sdk.kotlin.services.networkfirewall.model.Header.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (action == null) action = StatefulAction.SdkUnknown("no value provided")
            if (ruleOptions == null) ruleOptions = emptyList()
            return this
        }
    }
}
