// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the amount of time that can pass without any traffic sent through the firewall before the firewall determines that the connection is idle and Network Firewall removes the flow entry from its flow table. Existing connections and flows are not impacted when you update this value. Only new connections after you update this value are impacted.
 */
public class FlowTimeouts private constructor(builder: Builder) {
    /**
     * The number of seconds that can pass without any TCP traffic sent through the firewall before the firewall determines that the connection is idle. After the idle timeout passes, data packets are dropped, however, the next TCP SYN packet is considered a new flow and is processed by the firewall. Clients or targets can use TCP keepalive packets to reset the idle timeout.
     *
     * You can define the `TcpIdleTimeoutSeconds` value to be between 60 and 6000 seconds. If no value is provided, it defaults to 350 seconds.
     */
    public val tcpIdleTimeoutSeconds: kotlin.Int? = builder.tcpIdleTimeoutSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.FlowTimeouts = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FlowTimeouts(")
        append("tcpIdleTimeoutSeconds=$tcpIdleTimeoutSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = tcpIdleTimeoutSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FlowTimeouts

        if (tcpIdleTimeoutSeconds != other.tcpIdleTimeoutSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.FlowTimeouts = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of seconds that can pass without any TCP traffic sent through the firewall before the firewall determines that the connection is idle. After the idle timeout passes, data packets are dropped, however, the next TCP SYN packet is considered a new flow and is processed by the firewall. Clients or targets can use TCP keepalive packets to reset the idle timeout.
         *
         * You can define the `TcpIdleTimeoutSeconds` value to be between 60 and 6000 seconds. If no value is provided, it defaults to 350 seconds.
         */
        public var tcpIdleTimeoutSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.FlowTimeouts) : this() {
            this.tcpIdleTimeoutSeconds = x.tcpIdleTimeoutSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.FlowTimeouts = FlowTimeouts(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
