// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines where Network Firewall sends logs for the firewall for one log type. This is used in LoggingConfiguration. You can send each type of log to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
 *
 * Network Firewall generates logs for stateful rule groups. You can save alert, flow, and TLS log types.
 */
public class LogDestinationConfig private constructor(builder: Builder) {
    /**
     * The named location for the logs, provided in a key:value mapping that is specific to the chosen destination type.
     * + For an Amazon S3 bucket, provide the name of the bucket, with key `bucketName`, and optionally provide a prefix, with key `prefix`. The following example specifies an Amazon S3 bucket named `DOC-EXAMPLE-BUCKET` and the prefix `alerts`: `"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }`
     * + For a CloudWatch log group, provide the name of the CloudWatch log group, with key `logGroup`. The following example specifies a log group named `alert-log-group`: `"LogDestination": { "logGroup": "alert-log-group" }`
     * + For a Firehose delivery stream, provide the name of the delivery stream, with key `deliveryStream`. The following example specifies a delivery stream named `alert-delivery-stream`: `"LogDestination": { "deliveryStream": "alert-delivery-stream" }`
     */
    public val logDestination: Map<String, String> = requireNotNull(builder.logDestination) { "A non-null value must be provided for logDestination" }
    /**
     * The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
     */
    public val logDestinationType: aws.sdk.kotlin.services.networkfirewall.model.LogDestinationType = requireNotNull(builder.logDestinationType) { "A non-null value must be provided for logDestinationType" }
    /**
     * The type of log to record. You can record the following types of logs from your Network Firewall stateful engine.
     * + `ALERT` - Logs for traffic that matches your stateful rules and that have an action that sends an alert. A stateful rule sends alerts for the rule actions DROP, ALERT, and REJECT. For more information, see StatefulRule.
     * + `FLOW` - Standard network traffic flow logs. The stateful rules engine records flow logs for all network traffic that it receives. Each flow log record captures the network flow for a specific standard stateless rule group.
     * + `TLS` - Logs for events that are related to TLS inspection. For more information, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-configurations.html) in the *Network Firewall Developer Guide*.
     */
    public val logType: aws.sdk.kotlin.services.networkfirewall.model.LogType = requireNotNull(builder.logType) { "A non-null value must be provided for logType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.LogDestinationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogDestinationConfig(")
        append("logDestination=$logDestination,")
        append("logDestinationType=$logDestinationType,")
        append("logType=$logType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logDestination.hashCode()
        result = 31 * result + (logDestinationType.hashCode())
        result = 31 * result + (logType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogDestinationConfig

        if (logDestination != other.logDestination) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logType != other.logType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.LogDestinationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The named location for the logs, provided in a key:value mapping that is specific to the chosen destination type.
         * + For an Amazon S3 bucket, provide the name of the bucket, with key `bucketName`, and optionally provide a prefix, with key `prefix`. The following example specifies an Amazon S3 bucket named `DOC-EXAMPLE-BUCKET` and the prefix `alerts`: `"LogDestination": { "bucketName": "DOC-EXAMPLE-BUCKET", "prefix": "alerts" }`
         * + For a CloudWatch log group, provide the name of the CloudWatch log group, with key `logGroup`. The following example specifies a log group named `alert-log-group`: `"LogDestination": { "logGroup": "alert-log-group" }`
         * + For a Firehose delivery stream, provide the name of the delivery stream, with key `deliveryStream`. The following example specifies a delivery stream named `alert-delivery-stream`: `"LogDestination": { "deliveryStream": "alert-delivery-stream" }`
         */
        public var logDestination: Map<String, String>? = null
        /**
         * The type of storage destination to send these logs to. You can send logs to an Amazon S3 bucket, a CloudWatch log group, or a Firehose delivery stream.
         */
        public var logDestinationType: aws.sdk.kotlin.services.networkfirewall.model.LogDestinationType? = null
        /**
         * The type of log to record. You can record the following types of logs from your Network Firewall stateful engine.
         * + `ALERT` - Logs for traffic that matches your stateful rules and that have an action that sends an alert. A stateful rule sends alerts for the rule actions DROP, ALERT, and REJECT. For more information, see StatefulRule.
         * + `FLOW` - Standard network traffic flow logs. The stateful rules engine records flow logs for all network traffic that it receives. Each flow log record captures the network flow for a specific standard stateless rule group.
         * + `TLS` - Logs for events that are related to TLS inspection. For more information, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-configurations.html) in the *Network Firewall Developer Guide*.
         */
        public var logType: aws.sdk.kotlin.services.networkfirewall.model.LogType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.LogDestinationConfig) : this() {
            this.logDestination = x.logDestination
            this.logDestinationType = x.logDestinationType
            this.logType = x.logType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.LogDestinationConfig = LogDestinationConfig(this)

        internal fun correctErrors(): Builder {
            if (logDestination == null) logDestination = emptyMap()
            if (logDestinationType == null) logDestinationType = LogDestinationType.SdkUnknown("no value provided")
            if (logType == null) logType = LogType.SdkUnknown("no value provided")
            return this
        }
    }
}
