// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFirewallRequest private constructor(builder: Builder) {
    /**
     * A flag indicating whether it is possible to delete the firewall. A setting of `TRUE` indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to `TRUE`.
     */
    public val deleteProtection: kotlin.Boolean? = builder.deleteProtection
    /**
     * A description of the firewall.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains settings for encryption of your firewall resources.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     */
    public val firewallName: kotlin.String? = builder.firewallName
    /**
     * The Amazon Resource Name (ARN) of the FirewallPolicy that you want to use for the firewall.
     */
    public val firewallPolicyArn: kotlin.String? = builder.firewallPolicyArn
    /**
     * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
     */
    public val firewallPolicyChangeProtection: kotlin.Boolean? = builder.firewallPolicyChangeProtection
    /**
     * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
     */
    public val subnetChangeProtection: kotlin.Boolean? = builder.subnetChangeProtection
    /**
     * The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
     */
    public val subnetMappings: List<SubnetMapping>? = builder.subnetMappings
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The unique identifier of the VPC where Network Firewall should create the firewall.
     *
     * You can't change this setting after you create the firewall.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFirewallRequest(")
        append("deleteProtection=$deleteProtection,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("firewallName=$firewallName,")
        append("firewallPolicyArn=$firewallPolicyArn,")
        append("firewallPolicyChangeProtection=$firewallPolicyChangeProtection,")
        append("subnetChangeProtection=$subnetChangeProtection,")
        append("subnetMappings=$subnetMappings,")
        append("tags=$tags,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteProtection?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (firewallName?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyChangeProtection?.hashCode() ?: 0)
        result = 31 * result + (subnetChangeProtection?.hashCode() ?: 0)
        result = 31 * result + (subnetMappings?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFirewallRequest

        if (deleteProtection != other.deleteProtection) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (firewallName != other.firewallName) return false
        if (firewallPolicyArn != other.firewallPolicyArn) return false
        if (firewallPolicyChangeProtection != other.firewallPolicyChangeProtection) return false
        if (subnetChangeProtection != other.subnetChangeProtection) return false
        if (subnetMappings != other.subnetMappings) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A flag indicating whether it is possible to delete the firewall. A setting of `TRUE` indicates that the firewall is protected against deletion. Use this setting to protect against accidentally deleting a firewall that is in use. When you create a firewall, the operation initializes this flag to `TRUE`.
         */
        public var deleteProtection: kotlin.Boolean? = null
        /**
         * A description of the firewall.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains settings for encryption of your firewall resources.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         */
        public var firewallName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the FirewallPolicy that you want to use for the firewall.
         */
        public var firewallPolicyArn: kotlin.String? = null
        /**
         * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
         */
        public var firewallPolicyChangeProtection: kotlin.Boolean? = null
        /**
         * A setting indicating whether the firewall is protected against changes to the subnet associations. Use this setting to protect against accidentally modifying the subnet associations for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
         */
        public var subnetChangeProtection: kotlin.Boolean? = null
        /**
         * The public subnets to use for your Network Firewall firewalls. Each subnet must belong to a different Availability Zone in the VPC. Network Firewall creates a firewall endpoint in each subnet.
         */
        public var subnetMappings: List<SubnetMapping>? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The unique identifier of the VPC where Network Firewall should create the firewall.
         *
         * You can't change this setting after you create the firewall.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallRequest) : this() {
            this.deleteProtection = x.deleteProtection
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.firewallName = x.firewallName
            this.firewallPolicyArn = x.firewallPolicyArn
            this.firewallPolicyChangeProtection = x.firewallPolicyChangeProtection
            this.subnetChangeProtection = x.subnetChangeProtection
            this.subnetMappings = x.subnetMappings
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallRequest = CreateFirewallRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
