// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The analysis result for Network Firewall's stateless rule group analyzer. Every time you call CreateRuleGroup, UpdateRuleGroup, or DescribeRuleGroup on a stateless rule group, Network Firewall analyzes the stateless rule groups in your account and identifies the rules that might adversely effect your firewall's functionality. For example, if Network Firewall detects a rule that's routing traffic asymmetrically, which impacts the service's ability to properly process traffic, the service includes the rule in a list of analysis results.
 */
public class AnalysisResult private constructor(builder: Builder) {
    /**
     * Provides analysis details for the identified rule.
     */
    public val analysisDetail: kotlin.String? = builder.analysisDetail
    /**
     * The priority number of the stateless rules identified in the analysis.
     */
    public val identifiedRuleIds: List<String>? = builder.identifiedRuleIds
    /**
     * The types of rule configurations that Network Firewall analyzes your rule groups for. Network Firewall analyzes stateless rule groups for the following types of rule configurations:
     * + `STATELESS_RULE_FORWARDING_ASYMMETRICALLY`Cause: One or more stateless rules with the action `pass` or `forward` are forwarding traffic asymmetrically. Specifically, the rule's set of source IP addresses or their associated port numbers, don't match the set of destination IP addresses or their associated port numbers.To mitigate: Make sure that there's an existing return path. For example, if the rule allows traffic from source 10.1.0.0/24 to destination 20.1.0.0/24, you should allow return traffic from source 20.1.0.0/24 to destination 10.1.0.0/24.
     * + `STATELESS_RULE_CONTAINS_TCP_FLAGS`Cause: At least one stateless rule with the action `pass` or`forward` contains TCP flags that are inconsistent in the forward and return directions.To mitigate: Prevent asymmetric routing issues caused by TCP flags by following these actions:
     *    + Remove unnecessary TCP flag inspections from the rules.
     *    + If you need to inspect TCP flags, check that the rules correctly account for changes in TCP flags throughout the TCP connection cycle, for example `SYN` and `ACK` flags used in a 3-way TCP handshake.
     */
    public val identifiedType: aws.sdk.kotlin.services.networkfirewall.model.IdentifiedType? = builder.identifiedType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.AnalysisResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisResult(")
        append("analysisDetail=$analysisDetail,")
        append("identifiedRuleIds=$identifiedRuleIds,")
        append("identifiedType=$identifiedType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisDetail?.hashCode() ?: 0
        result = 31 * result + (identifiedRuleIds?.hashCode() ?: 0)
        result = 31 * result + (identifiedType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalysisResult

        if (analysisDetail != other.analysisDetail) return false
        if (identifiedRuleIds != other.identifiedRuleIds) return false
        if (identifiedType != other.identifiedType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.AnalysisResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Provides analysis details for the identified rule.
         */
        public var analysisDetail: kotlin.String? = null
        /**
         * The priority number of the stateless rules identified in the analysis.
         */
        public var identifiedRuleIds: List<String>? = null
        /**
         * The types of rule configurations that Network Firewall analyzes your rule groups for. Network Firewall analyzes stateless rule groups for the following types of rule configurations:
         * + `STATELESS_RULE_FORWARDING_ASYMMETRICALLY`Cause: One or more stateless rules with the action `pass` or `forward` are forwarding traffic asymmetrically. Specifically, the rule's set of source IP addresses or their associated port numbers, don't match the set of destination IP addresses or their associated port numbers.To mitigate: Make sure that there's an existing return path. For example, if the rule allows traffic from source 10.1.0.0/24 to destination 20.1.0.0/24, you should allow return traffic from source 20.1.0.0/24 to destination 10.1.0.0/24.
         * + `STATELESS_RULE_CONTAINS_TCP_FLAGS`Cause: At least one stateless rule with the action `pass` or`forward` contains TCP flags that are inconsistent in the forward and return directions.To mitigate: Prevent asymmetric routing issues caused by TCP flags by following these actions:
         *    + Remove unnecessary TCP flag inspections from the rules.
         *    + If you need to inspect TCP flags, check that the rules correctly account for changes in TCP flags throughout the TCP connection cycle, for example `SYN` and `ACK` flags used in a 3-way TCP handshake.
         */
        public var identifiedType: aws.sdk.kotlin.services.networkfirewall.model.IdentifiedType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.AnalysisResult) : this() {
            this.analysisDetail = x.analysisDetail
            this.identifiedRuleIds = x.identifiedRuleIds
            this.identifiedType = x.identifiedType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.AnalysisResult = AnalysisResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
