// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.serde

import aws.sdk.kotlin.services.networkfirewall.model.NetworkFirewallException
import aws.sdk.kotlin.services.networkfirewall.model.UpdateSubnetChangeProtectionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSubnetChangeProtectionOperationDeserializer: HttpDeserializer.NonStreaming<UpdateSubnetChangeProtectionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateSubnetChangeProtectionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSubnetChangeProtectionError(context, call, payload)
        }
        val builder = UpdateSubnetChangeProtectionResponse.Builder()

        if (payload != null) {
            deserializeUpdateSubnetChangeProtectionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateSubnetChangeProtectionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkFirewallException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTokenException" -> InvalidTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceOwnerCheckException" -> ResourceOwnerCheckExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> NetworkFirewallException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSubnetChangeProtectionOperationBody(builder: UpdateSubnetChangeProtectionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FIREWALLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirewallArn"))
    val FIREWALLNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirewallName"))
    val SUBNETCHANGEPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("SubnetChangeProtection"))
    val UPDATETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UpdateToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FIREWALLARN_DESCRIPTOR)
        field(FIREWALLNAME_DESCRIPTOR)
        field(SUBNETCHANGEPROTECTION_DESCRIPTOR)
        field(UPDATETOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FIREWALLARN_DESCRIPTOR.index -> builder.firewallArn = deserializeString()
                FIREWALLNAME_DESCRIPTOR.index -> builder.firewallName = deserializeString()
                SUBNETCHANGEPROTECTION_DESCRIPTOR.index -> builder.subnetChangeProtection = deserializeBoolean()
                UPDATETOKEN_DESCRIPTOR.index -> builder.updateToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
