// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.serde

import aws.sdk.kotlin.services.networkfirewall.model.DescribeLoggingConfigurationResponse
import aws.sdk.kotlin.services.networkfirewall.model.LoggingConfiguration
import aws.sdk.kotlin.services.networkfirewall.model.NetworkFirewallException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeLoggingConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeLoggingConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeLoggingConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLoggingConfigurationError(context, call, payload)
        }
        val builder = DescribeLoggingConfigurationResponse.Builder()

        if (payload != null) {
            deserializeDescribeLoggingConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeLoggingConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkFirewallException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> NetworkFirewallException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLoggingConfigurationOperationBody(builder: DescribeLoggingConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FIREWALLARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirewallArn"))
    val LOGGINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LoggingConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FIREWALLARN_DESCRIPTOR)
        field(LOGGINGCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FIREWALLARN_DESCRIPTOR.index -> builder.firewallArn = deserializeString()
                LOGGINGCONFIGURATION_DESCRIPTOR.index -> builder.loggingConfiguration = deserializeLoggingConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
