// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeRuleGroupMetadataResponse private constructor(builder: Builder) {
    /**
     * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
     *
     * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with `DryRun` set to `TRUE`.
     */
    public val capacity: kotlin.Int? = builder.capacity
    /**
     * Returns the metadata objects for the specified rule group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The last time that the rule group was changed.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    public val ruleGroupArn: kotlin.String = requireNotNull(builder.ruleGroupArn) { "A non-null value must be provided for ruleGroupArn" }
    /**
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    public val ruleGroupName: kotlin.String = requireNotNull(builder.ruleGroupName) { "A non-null value must be provided for ruleGroupName" }
    /**
     * Additional options governing how Network Firewall handles the rule group. You can only use these for stateful rule groups.
     */
    public val statefulRuleOptions: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions? = builder.statefulRuleOptions
    /**
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
     *
     * This setting is required for requests that do not include the `RuleGroupARN`.
     */
    public val type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeRuleGroupMetadataResponse(")
        append("capacity=$capacity,")
        append("description=$description,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("ruleGroupArn=$ruleGroupArn,")
        append("ruleGroupName=$ruleGroupName,")
        append("statefulRuleOptions=$statefulRuleOptions,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupArn.hashCode())
        result = 31 * result + (ruleGroupName.hashCode())
        result = 31 * result + (statefulRuleOptions?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeRuleGroupMetadataResponse

        if (capacity != other.capacity) return false
        if (description != other.description) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (ruleGroupArn != other.ruleGroupArn) return false
        if (ruleGroupName != other.ruleGroupName) return false
        if (statefulRuleOptions != other.statefulRuleOptions) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
         *
         * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with `DryRun` set to `TRUE`.
         */
        public var capacity: kotlin.Int? = null
        /**
         * Returns the metadata objects for the specified rule group.
         */
        public var description: kotlin.String? = null
        /**
         * The last time that the rule group was changed.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        public var ruleGroupArn: kotlin.String? = null
        /**
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        public var ruleGroupName: kotlin.String? = null
        /**
         * Additional options governing how Network Firewall handles the rule group. You can only use these for stateful rule groups.
         */
        public var statefulRuleOptions: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions? = null
        /**
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
         *
         * This setting is required for requests that do not include the `RuleGroupARN`.
         */
        public var type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataResponse) : this() {
            this.capacity = x.capacity
            this.description = x.description
            this.lastModifiedTime = x.lastModifiedTime
            this.ruleGroupArn = x.ruleGroupArn
            this.ruleGroupName = x.ruleGroupName
            this.statefulRuleOptions = x.statefulRuleOptions
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.DescribeRuleGroupMetadataResponse = DescribeRuleGroupMetadataResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions] inside the given [block]
         */
        public fun statefulRuleOptions(block: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions.Builder.() -> kotlin.Unit) {
            this.statefulRuleOptions = aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (ruleGroupArn == null) ruleGroupArn = ""
            if (ruleGroupName == null) ruleGroupName = ""
            return this
        }
    }
}
