// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The high-level properties of a rule group. This, along with the RuleGroup, define the rule group. You can retrieve all objects for a rule group by calling DescribeRuleGroup.
 */
public class RuleGroupResponse private constructor(builder: Builder) {
    /**
     * The list of analysis results for `AnalyzeRuleGroup`. If you set `AnalyzeRuleGroup` to `TRUE` in CreateRuleGroup, UpdateRuleGroup, or DescribeRuleGroup, Network Firewall analyzes the rule group and identifies the rules that might adversely effect your firewall's functionality. For example, if Network Firewall detects a rule that's routing traffic asymmetrically, which impacts the service's ability to properly process traffic, the service includes the rule in the list of analysis results.
     */
    public val analysisResults: List<AnalysisResult>? = builder.analysisResults
    /**
     * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
     *
     * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with `DryRun` set to `TRUE`.
     */
    public val capacity: kotlin.Int? = builder.capacity
    /**
     * The number of capacity units currently consumed by the rule group rules.
     */
    public val consumedCapacity: kotlin.Int? = builder.consumedCapacity
    /**
     * A description of the rule group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your rule group.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The last time that the rule group was changed.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The number of firewall policies that use this rule group.
     */
    public val numberOfAssociations: kotlin.Int? = builder.numberOfAssociations
    /**
     * The Amazon Resource Name (ARN) of the rule group.
     *
     * If this response is for a create request that had `DryRun` set to `TRUE`, then this ARN is a placeholder that isn't attached to a valid resource.
     */
    public val ruleGroupArn: kotlin.String = requireNotNull(builder.ruleGroupArn) { "A non-null value must be provided for ruleGroupArn" }
    /**
     * The unique identifier for the rule group.
     */
    public val ruleGroupId: kotlin.String = requireNotNull(builder.ruleGroupId) { "A non-null value must be provided for ruleGroupId" }
    /**
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     */
    public val ruleGroupName: kotlin.String = requireNotNull(builder.ruleGroupName) { "A non-null value must be provided for ruleGroupName" }
    /**
     * Detailed information about the current status of a rule group.
     */
    public val ruleGroupStatus: aws.sdk.kotlin.services.networkfirewall.model.ResourceStatus? = builder.ruleGroupStatus
    /**
     * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to record changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the [Amazon Simple Notification Service Developer Guide.](https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
     */
    public val snsTopic: kotlin.String? = builder.snsTopic
    /**
     * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to track the version updates made to the originating rule group.
     */
    public val sourceMetadata: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata? = builder.sourceMetadata
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
     */
    public val type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.RuleGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroupResponse(")
        append("analysisResults=$analysisResults,")
        append("capacity=$capacity,")
        append("consumedCapacity=$consumedCapacity,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("numberOfAssociations=$numberOfAssociations,")
        append("ruleGroupArn=$ruleGroupArn,")
        append("ruleGroupId=$ruleGroupId,")
        append("ruleGroupName=$ruleGroupName,")
        append("ruleGroupStatus=$ruleGroupStatus,")
        append("snsTopic=$snsTopic,")
        append("sourceMetadata=$sourceMetadata,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisResults?.hashCode() ?: 0
        result = 31 * result + (capacity ?: 0)
        result = 31 * result + (consumedCapacity ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfAssociations ?: 0)
        result = 31 * result + (ruleGroupArn.hashCode())
        result = 31 * result + (ruleGroupId.hashCode())
        result = 31 * result + (ruleGroupName.hashCode())
        result = 31 * result + (ruleGroupStatus?.hashCode() ?: 0)
        result = 31 * result + (snsTopic?.hashCode() ?: 0)
        result = 31 * result + (sourceMetadata?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroupResponse

        if (analysisResults != other.analysisResults) return false
        if (capacity != other.capacity) return false
        if (consumedCapacity != other.consumedCapacity) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (numberOfAssociations != other.numberOfAssociations) return false
        if (ruleGroupArn != other.ruleGroupArn) return false
        if (ruleGroupId != other.ruleGroupId) return false
        if (ruleGroupName != other.ruleGroupName) return false
        if (ruleGroupStatus != other.ruleGroupStatus) return false
        if (snsTopic != other.snsTopic) return false
        if (sourceMetadata != other.sourceMetadata) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.RuleGroupResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of analysis results for `AnalyzeRuleGroup`. If you set `AnalyzeRuleGroup` to `TRUE` in CreateRuleGroup, UpdateRuleGroup, or DescribeRuleGroup, Network Firewall analyzes the rule group and identifies the rules that might adversely effect your firewall's functionality. For example, if Network Firewall detects a rule that's routing traffic asymmetrically, which impacts the service's ability to properly process traffic, the service includes the rule in the list of analysis results.
         */
        public var analysisResults: List<AnalysisResult>? = null
        /**
         * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
         *
         * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with `DryRun` set to `TRUE`.
         */
        public var capacity: kotlin.Int? = null
        /**
         * The number of capacity units currently consumed by the rule group rules.
         */
        public var consumedCapacity: kotlin.Int? = null
        /**
         * A description of the rule group.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your rule group.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The last time that the rule group was changed.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of firewall policies that use this rule group.
         */
        public var numberOfAssociations: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the rule group.
         *
         * If this response is for a create request that had `DryRun` set to `TRUE`, then this ARN is a placeholder that isn't attached to a valid resource.
         */
        public var ruleGroupArn: kotlin.String? = null
        /**
         * The unique identifier for the rule group.
         */
        public var ruleGroupId: kotlin.String? = null
        /**
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         */
        public var ruleGroupName: kotlin.String? = null
        /**
         * Detailed information about the current status of a rule group.
         */
        public var ruleGroupStatus: aws.sdk.kotlin.services.networkfirewall.model.ResourceStatus? = null
        /**
         * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to record changes to the managed rule group. You can subscribe to the SNS topic to receive notifications when the managed rule group is modified, such as for new versions and for version expiration. For more information, see the [Amazon Simple Notification Service Developer Guide.](https://docs.aws.amazon.com/sns/latest/dg/welcome.html).
         */
        public var snsTopic: kotlin.String? = null
        /**
         * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to track the version updates made to the originating rule group.
         */
        public var sourceMetadata: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
         */
        public var type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupResponse) : this() {
            this.analysisResults = x.analysisResults
            this.capacity = x.capacity
            this.consumedCapacity = x.consumedCapacity
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.lastModifiedTime = x.lastModifiedTime
            this.numberOfAssociations = x.numberOfAssociations
            this.ruleGroupArn = x.ruleGroupArn
            this.ruleGroupId = x.ruleGroupId
            this.ruleGroupName = x.ruleGroupName
            this.ruleGroupStatus = x.ruleGroupStatus
            this.snsTopic = x.snsTopic
            this.sourceMetadata = x.sourceMetadata
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.RuleGroupResponse = RuleGroupResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata] inside the given [block]
         */
        public fun sourceMetadata(block: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata.Builder.() -> kotlin.Unit) {
            this.sourceMetadata = aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (ruleGroupArn == null) ruleGroupArn = ""
            if (ruleGroupId == null) ruleGroupId = ""
            if (ruleGroupName == null) ruleGroupName = ""
            return this
        }
    }
}
