// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFirewallPolicyRequest private constructor(builder: Builder) {
    /**
     * A description of the firewall policy.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
     *
     * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
     *
     * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A complex type that contains settings for encryption of your firewall policy resources.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The rule groups and policy actions to use in the firewall policy.
     */
    public val firewallPolicy: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy? = builder.firewallPolicy
    /**
     * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
     */
    public val firewallPolicyName: kotlin.String? = builder.firewallPolicyName
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFirewallPolicyRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("firewallPolicy=$firewallPolicy,")
        append("firewallPolicyName=$firewallPolicyName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicy?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFirewallPolicyRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (firewallPolicy != other.firewallPolicy) return false
        if (firewallPolicyName != other.firewallPolicyName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the firewall policy.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
         *
         * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
         *
         * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A complex type that contains settings for encryption of your firewall policy resources.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The rule groups and policy actions to use in the firewall policy.
         */
        public var firewallPolicy: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy? = null
        /**
         * The descriptive name of the firewall policy. You can't change the name of a firewall policy after you create it.
         */
        public var firewallPolicyName: kotlin.String? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.encryptionConfiguration = x.encryptionConfiguration
            this.firewallPolicy = x.firewallPolicy
            this.firewallPolicyName = x.firewallPolicyName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CreateFirewallPolicyRequest = CreateFirewallPolicyRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy] inside the given [block]
         */
        public fun firewallPolicy(block: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy.Builder.() -> kotlin.Unit) {
            this.firewallPolicy = aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
