// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configures the Certificate Manager certificates and scope that Network Firewall uses to decrypt and re-encrypt traffic using a TLSInspectionConfiguration. You can configure `ServerCertificates` for inbound SSL/TLS inspection, a `CertificateAuthorityArn` for outbound SSL/TLS inspection, or both. For information about working with certificates for TLS inspection, see [ Using SSL/TLS server certficiates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) in the *Network Firewall Developer Guide*.
 *
 * If a server certificate that's associated with your TLSInspectionConfiguration is revoked, deleted, or expired it can result in client-side TLS errors.
 */
public class ServerCertificateConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection.
     *
     * The following limitations apply:
     * + You can use CA certificates that you imported into ACM, but you can't generate CA certificates with ACM.
     * + You can't use certificates issued by Private Certificate Authority.
     *
     * For more information about configuring certificates for outbound inspection, see [Using SSL/TLS certificates with certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) in the *Network Firewall Developer Guide*.
     *
     * For information about working with certificates in ACM, see [Importing certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
     */
    public val certificateAuthorityArn: kotlin.String? = builder.certificateAuthorityArn
    /**
     * When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a `CertificateAuthorityArn` in ServerCertificateConfiguration.
     */
    public val checkCertificateRevocationStatus: aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions? = builder.checkCertificateRevocationStatus
    /**
     * A list of scopes.
     */
    public val scopes: List<ServerCertificateScope>? = builder.scopes
    /**
     * The list of server certificates to use for inbound SSL/TLS inspection.
     */
    public val serverCertificates: List<ServerCertificate>? = builder.serverCertificates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerCertificateConfiguration(")
        append("certificateAuthorityArn=$certificateAuthorityArn,")
        append("checkCertificateRevocationStatus=$checkCertificateRevocationStatus,")
        append("scopes=$scopes,")
        append("serverCertificates=$serverCertificates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthorityArn?.hashCode() ?: 0
        result = 31 * result + (checkCertificateRevocationStatus?.hashCode() ?: 0)
        result = 31 * result + (scopes?.hashCode() ?: 0)
        result = 31 * result + (serverCertificates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerCertificateConfiguration

        if (certificateAuthorityArn != other.certificateAuthorityArn) return false
        if (checkCertificateRevocationStatus != other.checkCertificateRevocationStatus) return false
        if (scopes != other.scopes) return false
        if (serverCertificates != other.serverCertificates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the imported certificate authority (CA) certificate within Certificate Manager (ACM) to use for outbound SSL/TLS inspection.
         *
         * The following limitations apply:
         * + You can use CA certificates that you imported into ACM, but you can't generate CA certificates with ACM.
         * + You can't use certificates issued by Private Certificate Authority.
         *
         * For more information about configuring certificates for outbound inspection, see [Using SSL/TLS certificates with certificates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) in the *Network Firewall Developer Guide*.
         *
         * For information about working with certificates in ACM, see [Importing certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *Certificate Manager User Guide*.
         */
        public var certificateAuthorityArn: kotlin.String? = null
        /**
         * When enabled, Network Firewall checks if the server certificate presented by the server in the SSL/TLS connection has a revoked or unkown status. If the certificate has an unknown or revoked status, you must specify the actions that Network Firewall takes on outbound traffic. To check the certificate revocation status, you must also specify a `CertificateAuthorityArn` in ServerCertificateConfiguration.
         */
        public var checkCertificateRevocationStatus: aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions? = null
        /**
         * A list of scopes.
         */
        public var scopes: List<ServerCertificateScope>? = null
        /**
         * The list of server certificates to use for inbound SSL/TLS inspection.
         */
        public var serverCertificates: List<ServerCertificate>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration) : this() {
            this.certificateAuthorityArn = x.certificateAuthorityArn
            this.checkCertificateRevocationStatus = x.checkCertificateRevocationStatus
            this.scopes = x.scopes
            this.serverCertificates = x.serverCertificates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration = ServerCertificateConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions] inside the given [block]
         */
        public fun checkCertificateRevocationStatus(block: aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions.Builder.() -> kotlin.Unit) {
            this.checkCertificateRevocationStatus = aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
