// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the actions to take on the SSL/TLS connection if the certificate presented by the server in the connection has a revoked or unknown status.
 */
public class CheckCertificateRevocationStatusActions private constructor(builder: Builder) {
    /**
     * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has a revoked status.
     * + **PASS** - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.
     * + **DROP** - Network Firewall closes the connection and drops subsequent packets for that connection.
     * + **REJECT** - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. `REJECT` is available only for TCP traffic.
     */
    public val revokedStatusAction: aws.sdk.kotlin.services.networkfirewall.model.RevocationCheckAction? = builder.revokedStatusAction
    /**
     * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
     * + **PASS** - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.
     * + **DROP** - Network Firewall closes the connection and drops subsequent packets for that connection.
     * + **REJECT** - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. `REJECT` is available only for TCP traffic.
     */
    public val unknownStatusAction: aws.sdk.kotlin.services.networkfirewall.model.RevocationCheckAction? = builder.unknownStatusAction

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CheckCertificateRevocationStatusActions(")
        append("revokedStatusAction=$revokedStatusAction,")
        append("unknownStatusAction=$unknownStatusAction")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = revokedStatusAction?.hashCode() ?: 0
        result = 31 * result + (unknownStatusAction?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CheckCertificateRevocationStatusActions

        if (revokedStatusAction != other.revokedStatusAction) return false
        if (unknownStatusAction != other.unknownStatusAction) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has a revoked status.
         * + **PASS** - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.
         * + **DROP** - Network Firewall closes the connection and drops subsequent packets for that connection.
         * + **REJECT** - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. `REJECT` is available only for TCP traffic.
         */
        public var revokedStatusAction: aws.sdk.kotlin.services.networkfirewall.model.RevocationCheckAction? = null
        /**
         * Configures how Network Firewall processes traffic when it determines that the certificate presented by the server in the SSL/TLS connection has an unknown status, or a status that cannot be determined for any other reason, including when the service is unable to connect to the OCSP and CRL endpoints for the certificate.
         * + **PASS** - Allow the connection to continue, and pass subsequent packets to the stateful engine for inspection.
         * + **DROP** - Network Firewall closes the connection and drops subsequent packets for that connection.
         * + **REJECT** - Network Firewall sends a TCP reject packet back to your client. The service closes the connection and drops subsequent packets for that connection. `REJECT` is available only for TCP traffic.
         */
        public var unknownStatusAction: aws.sdk.kotlin.services.networkfirewall.model.RevocationCheckAction? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions) : this() {
            this.revokedStatusAction = x.revokedStatusAction
            this.unknownStatusAction = x.unknownStatusAction
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CheckCertificateRevocationStatusActions = CheckCertificateRevocationStatusActions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
