// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration and status for a single subnet that you've specified for use by the Network Firewall firewall. This is part of the FirewallStatus.
 */
public class Attachment private constructor(builder: Builder) {
    /**
     * The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the endpoint.
     */
    public val endpointId: kotlin.String? = builder.endpointId
    /**
     * The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the endpoint in the VPC subnet and the sync states that are reported in the `Config` settings. When this value is `READY`, the endpoint is available and configured properly to handle network traffic. When the endpoint isn't available for traffic, this value will reflect its state, for example `CREATING` or `DELETING`.
     */
    public val status: aws.sdk.kotlin.services.networkfirewall.model.AttachmentStatus? = builder.status
    /**
     * If Network Firewall fails to create or delete the firewall endpoint in the subnet, it populates this with the reason for the error or failure and how to resolve it. A `FAILED` status indicates a non-recoverable state, and a `ERROR` status indicates an issue that you can fix. Depending on the error, it can take as many as 15 minutes to populate this field. For more information about the causes for failiure or errors and solutions available for this field, see [Troubleshooting firewall endpoint failures](https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html) in the *Network Firewall Developer Guide*.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The unique identifier of the subnet that you've specified to be used for a firewall endpoint.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.Attachment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Attachment(")
        append("endpointId=$endpointId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointId?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Attachment

        if (endpointId != other.endpointId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.Attachment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier of the firewall endpoint that Network Firewall has instantiated in the subnet. You use this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the endpoint.
         */
        public var endpointId: kotlin.String? = null
        /**
         * The current status of the firewall endpoint in the subnet. This value reflects both the instantiation of the endpoint in the VPC subnet and the sync states that are reported in the `Config` settings. When this value is `READY`, the endpoint is available and configured properly to handle network traffic. When the endpoint isn't available for traffic, this value will reflect its state, for example `CREATING` or `DELETING`.
         */
        public var status: aws.sdk.kotlin.services.networkfirewall.model.AttachmentStatus? = null
        /**
         * If Network Firewall fails to create or delete the firewall endpoint in the subnet, it populates this with the reason for the error or failure and how to resolve it. A `FAILED` status indicates a non-recoverable state, and a `ERROR` status indicates an issue that you can fix. Depending on the error, it can take as many as 15 minutes to populate this field. For more information about the causes for failiure or errors and solutions available for this field, see [Troubleshooting firewall endpoint failures](https://docs.aws.amazon.com/network-firewall/latest/developerguide/firewall-troubleshooting-endpoint-failures.html) in the *Network Firewall Developer Guide*.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The unique identifier of the subnet that you've specified to be used for a firewall endpoint.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.Attachment) : this() {
            this.endpointId = x.endpointId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.Attachment = Attachment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
