// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class UpdateTlsInspectionConfigurationRequest private constructor(builder: Builder) {
    /**
     * A description of the TLS inspection configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS inspection configuration.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
     *
     * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
     *
     * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
     */
    public val tlsInspectionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration? = builder.tlsInspectionConfiguration
    /**
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     */
    public val tlsInspectionConfigurationArn: kotlin.String? = builder.tlsInspectionConfigurationArn
    /**
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection configuration after you create it.
     */
    public val tlsInspectionConfigurationName: kotlin.String? = builder.tlsInspectionConfigurationName
    /**
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request.
     *
     * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public val updateToken: kotlin.String? = builder.updateToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateTlsInspectionConfigurationRequest(")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("tlsInspectionConfiguration=$tlsInspectionConfiguration,")
        append("tlsInspectionConfigurationArn=$tlsInspectionConfigurationArn,")
        append("tlsInspectionConfigurationName=$tlsInspectionConfigurationName,")
        append("updateToken=$updateToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tlsInspectionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tlsInspectionConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (tlsInspectionConfigurationName?.hashCode() ?: 0)
        result = 31 * result + (updateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateTlsInspectionConfigurationRequest

        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (tlsInspectionConfiguration != other.tlsInspectionConfiguration) return false
        if (tlsInspectionConfigurationArn != other.tlsInspectionConfigurationArn) return false
        if (tlsInspectionConfigurationName != other.tlsInspectionConfigurationName) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the TLS inspection configuration.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS inspection configuration.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
         *
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
         *
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
         */
        public var tlsInspectionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the TLS inspection configuration.
         */
        public var tlsInspectionConfigurationArn: kotlin.String? = null
        /**
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection configuration after you create it.
         */
        public var tlsInspectionConfigurationName: kotlin.String? = null
        /**
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request.
         *
         * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
         */
        public var updateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest) : this() {
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.tlsInspectionConfiguration = x.tlsInspectionConfiguration
            this.tlsInspectionConfigurationArn = x.tlsInspectionConfigurationArn
            this.tlsInspectionConfigurationName = x.tlsInspectionConfigurationName
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.UpdateTlsInspectionConfigurationRequest = UpdateTlsInspectionConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration] inside the given [block]
         */
        public fun tlsInspectionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration.Builder.() -> kotlin.Unit) {
            this.tlsInspectionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
