// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class UpdateFirewallPolicyChangeProtectionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the firewall.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    public val firewallArn: kotlin.String? = builder.firewallArn
    /**
     * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    public val firewallName: kotlin.String? = builder.firewallName
    /**
     * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
     */
    public val firewallPolicyChangeProtection: kotlin.Boolean? = builder.firewallPolicyChangeProtection
    /**
     * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.
     *
     * To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.
     *
     * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public val updateToken: kotlin.String? = builder.updateToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFirewallPolicyChangeProtectionRequest(")
        append("firewallArn=$firewallArn,")
        append("firewallName=$firewallName,")
        append("firewallPolicyChangeProtection=$firewallPolicyChangeProtection,")
        append("updateToken=$updateToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firewallArn?.hashCode() ?: 0
        result = 31 * result + (firewallName?.hashCode() ?: 0)
        result = 31 * result + (firewallPolicyChangeProtection?.hashCode() ?: 0)
        result = 31 * result + (updateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFirewallPolicyChangeProtectionRequest

        if (firewallArn != other.firewallArn) return false
        if (firewallName != other.firewallName) return false
        if (firewallPolicyChangeProtection != other.firewallPolicyChangeProtection) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the firewall.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        public var firewallArn: kotlin.String? = null
        /**
         * The descriptive name of the firewall. You can't change the name of a firewall after you create it.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        public var firewallName: kotlin.String? = null
        /**
         * A setting indicating whether the firewall is protected against a change to the firewall policy association. Use this setting to protect against accidentally modifying the firewall policy for a firewall that is in use. When you create a firewall, the operation initializes this setting to `TRUE`.
         */
        public var firewallPolicyChangeProtection: kotlin.Boolean? = null
        /**
         * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.
         *
         * To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.
         *
         * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
         */
        public var updateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest) : this() {
            this.firewallArn = x.firewallArn
            this.firewallName = x.firewallName
            this.firewallPolicyChangeProtection = x.firewallPolicyChangeProtection
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.UpdateFirewallPolicyChangeProtectionRequest = UpdateFirewallPolicyChangeProtectionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
