// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The high-level properties of a TLS inspection configuration. This, along with the `TLSInspectionConfiguration`, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling `DescribeTLSInspectionConfiguration`.
 */
public class TlsInspectionConfigurationResponse private constructor(builder: Builder) {
    /**
     * Contains metadata about an Certificate Manager certificate.
     */
    public val certificateAuthority: aws.sdk.kotlin.services.networkfirewall.model.TlsCertificateData? = builder.certificateAuthority
    /**
     * A list of the certificates associated with the TLS inspection configuration.
     */
    public val certificates: List<TlsCertificateData>? = builder.certificates
    /**
     * A description of the TLS inspection configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS inspection configuration.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The last time that the TLS inspection configuration was changed.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The number of firewall policies that use this TLS inspection configuration.
     */
    public val numberOfAssociations: kotlin.Int? = builder.numberOfAssociations
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the TLS inspection configuration.
     */
    public val tlsInspectionConfigurationArn: kotlin.String = requireNotNull(builder.tlsInspectionConfigurationArn) { "A non-null value must be provided for tlsInspectionConfigurationArn" }
    /**
     * A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create and list commands. You provide it to operations such as update and delete.
     */
    public val tlsInspectionConfigurationId: kotlin.String = requireNotNull(builder.tlsInspectionConfigurationId) { "A non-null value must be provided for tlsInspectionConfigurationId" }
    /**
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection configuration after you create it.
     */
    public val tlsInspectionConfigurationName: kotlin.String = requireNotNull(builder.tlsInspectionConfigurationName) { "A non-null value must be provided for tlsInspectionConfigurationName" }
    /**
     * Detailed information about the current status of a TLSInspectionConfiguration. You can retrieve this for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration and providing the TLS inspection configuration name and ARN.
     */
    public val tlsInspectionConfigurationStatus: aws.sdk.kotlin.services.networkfirewall.model.ResourceStatus? = builder.tlsInspectionConfigurationStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TlsInspectionConfigurationResponse(")
        append("certificateAuthority=$certificateAuthority,")
        append("certificates=$certificates,")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("numberOfAssociations=$numberOfAssociations,")
        append("tags=$tags,")
        append("tlsInspectionConfigurationArn=$tlsInspectionConfigurationArn,")
        append("tlsInspectionConfigurationId=$tlsInspectionConfigurationId,")
        append("tlsInspectionConfigurationName=$tlsInspectionConfigurationName,")
        append("tlsInspectionConfigurationStatus=$tlsInspectionConfigurationStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificateAuthority?.hashCode() ?: 0
        result = 31 * result + (certificates?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfAssociations ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tlsInspectionConfigurationArn.hashCode())
        result = 31 * result + (tlsInspectionConfigurationId.hashCode())
        result = 31 * result + (tlsInspectionConfigurationName.hashCode())
        result = 31 * result + (tlsInspectionConfigurationStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TlsInspectionConfigurationResponse

        if (certificateAuthority != other.certificateAuthority) return false
        if (certificates != other.certificates) return false
        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (numberOfAssociations != other.numberOfAssociations) return false
        if (tags != other.tags) return false
        if (tlsInspectionConfigurationArn != other.tlsInspectionConfigurationArn) return false
        if (tlsInspectionConfigurationId != other.tlsInspectionConfigurationId) return false
        if (tlsInspectionConfigurationName != other.tlsInspectionConfigurationName) return false
        if (tlsInspectionConfigurationStatus != other.tlsInspectionConfigurationStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains metadata about an Certificate Manager certificate.
         */
        public var certificateAuthority: aws.sdk.kotlin.services.networkfirewall.model.TlsCertificateData? = null
        /**
         * A list of the certificates associated with the TLS inspection configuration.
         */
        public var certificates: List<TlsCertificateData>? = null
        /**
         * A description of the TLS inspection configuration.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains the Amazon Web Services KMS encryption configuration settings for your TLS inspection configuration.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The last time that the TLS inspection configuration was changed.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of firewall policies that use this TLS inspection configuration.
         */
        public var numberOfAssociations: kotlin.Int? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The Amazon Resource Name (ARN) of the TLS inspection configuration.
         */
        public var tlsInspectionConfigurationArn: kotlin.String? = null
        /**
         * A unique identifier for the TLS inspection configuration. This ID is returned in the responses to create and list commands. You provide it to operations such as update and delete.
         */
        public var tlsInspectionConfigurationId: kotlin.String? = null
        /**
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection configuration after you create it.
         */
        public var tlsInspectionConfigurationName: kotlin.String? = null
        /**
         * Detailed information about the current status of a TLSInspectionConfiguration. You can retrieve this for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration and providing the TLS inspection configuration name and ARN.
         */
        public var tlsInspectionConfigurationStatus: aws.sdk.kotlin.services.networkfirewall.model.ResourceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse) : this() {
            this.certificateAuthority = x.certificateAuthority
            this.certificates = x.certificates
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.lastModifiedTime = x.lastModifiedTime
            this.numberOfAssociations = x.numberOfAssociations
            this.tags = x.tags
            this.tlsInspectionConfigurationArn = x.tlsInspectionConfigurationArn
            this.tlsInspectionConfigurationId = x.tlsInspectionConfigurationId
            this.tlsInspectionConfigurationName = x.tlsInspectionConfigurationName
            this.tlsInspectionConfigurationStatus = x.tlsInspectionConfigurationStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse = TlsInspectionConfigurationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.TlsCertificateData] inside the given [block]
         */
        public fun certificateAuthority(block: aws.sdk.kotlin.services.networkfirewall.model.TlsCertificateData.Builder.() -> kotlin.Unit) {
            this.certificateAuthority = aws.sdk.kotlin.services.networkfirewall.model.TlsCertificateData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (tlsInspectionConfigurationArn == null) tlsInspectionConfigurationArn = ""
            if (tlsInspectionConfigurationId == null) tlsInspectionConfigurationId = ""
            if (tlsInspectionConfigurationName == null) tlsInspectionConfigurationName = ""
            return this
        }
    }
}
