// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Configuration settings for the handling of the stateful rule groups in a firewall policy.
 */
public class StatefulEngineOptions private constructor(builder: Builder) {
    /**
     * Indicates how to manage the order of stateful rule evaluation for the policy. `STRICT_ORDER` is the default and recommended option. With `STRICT_ORDER`, provide your rules in the order that you want them to be evaluated. You can then choose one or more default actions for packets that don't match any rules. Choose `STRICT_ORDER` to have the stateful rules engine determine the evaluation order of your rules. The default action for this rule order is `PASS`, followed by `DROP`, `REJECT`, and `ALERT` actions. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on your settings. For more information, see [Evaluation order for stateful rules](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html) in the *Network Firewall Developer Guide*.
     */
    public val ruleOrder: aws.sdk.kotlin.services.networkfirewall.model.RuleOrder? = builder.ruleOrder
    /**
     * Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections can break due to disruptions in external networks or within the firewall itself.
     * + `DROP` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is the default behavior.
     * + `CONTINUE` - Network Firewall continues to apply rules to the subsequent traffic without context from traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you have a stateful rule to `drop http` traffic, Network Firewall won't match the traffic for this rule because the service won't have the context from session initialization defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a `flow:stateless` rule would still match, as would the `aws:drop_strict` default action.
     * + `REJECT` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. Network Firewall also sends a TCP reject packet back to your client so that the client can immediately establish a new session. Network Firewall will have context about the new session and will apply rules to the subsequent traffic.
     */
    public val streamExceptionPolicy: aws.sdk.kotlin.services.networkfirewall.model.StreamExceptionPolicy? = builder.streamExceptionPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatefulEngineOptions(")
        append("ruleOrder=$ruleOrder,")
        append("streamExceptionPolicy=$streamExceptionPolicy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ruleOrder?.hashCode() ?: 0
        result = 31 * result + (streamExceptionPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatefulEngineOptions

        if (ruleOrder != other.ruleOrder) return false
        if (streamExceptionPolicy != other.streamExceptionPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates how to manage the order of stateful rule evaluation for the policy. `STRICT_ORDER` is the default and recommended option. With `STRICT_ORDER`, provide your rules in the order that you want them to be evaluated. You can then choose one or more default actions for packets that don't match any rules. Choose `STRICT_ORDER` to have the stateful rules engine determine the evaluation order of your rules. The default action for this rule order is `PASS`, followed by `DROP`, `REJECT`, and `ALERT` actions. Stateful rules are provided to the rule engine as Suricata compatible strings, and Suricata evaluates them based on your settings. For more information, see [Evaluation order for stateful rules](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html) in the *Network Firewall Developer Guide*.
         */
        public var ruleOrder: aws.sdk.kotlin.services.networkfirewall.model.RuleOrder? = null
        /**
         * Configures how Network Firewall processes traffic when a network connection breaks midstream. Network connections can break due to disruptions in external networks or within the firewall itself.
         * + `DROP` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. This is the default behavior.
         * + `CONTINUE` - Network Firewall continues to apply rules to the subsequent traffic without context from traffic before the break. This impacts the behavior of rules that depend on this context. For example, if you have a stateful rule to `drop http` traffic, Network Firewall won't match the traffic for this rule because the service won't have the context from session initialization defining the application layer protocol as HTTP. However, this behavior is rule dependent—a TCP-layer rule using a `flow:stateless` rule would still match, as would the `aws:drop_strict` default action.
         * + `REJECT` - Network Firewall fails closed and drops all subsequent traffic going to the firewall. Network Firewall also sends a TCP reject packet back to your client so that the client can immediately establish a new session. Network Firewall will have context about the new session and will apply rules to the subsequent traffic.
         */
        public var streamExceptionPolicy: aws.sdk.kotlin.services.networkfirewall.model.StreamExceptionPolicy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions) : this() {
            this.ruleOrder = x.ruleOrder
            this.streamExceptionPolicy = x.streamExceptionPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions = StatefulEngineOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
