// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The basic rule criteria for Network Firewall to use to inspect packet headers in stateful traffic flow inspection. Traffic flows that match the criteria are a match for the corresponding StatefulRule.
 */
public class Header private constructor(builder: Builder) {
    /**
     * The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
     *
     * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
     *
     * Examples:
     * + To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32`.
     * + To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
     * + To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
     * + To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
     *
     * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     */
    public val destination: kotlin.String = requireNotNull(builder.destination) { "A non-null value must be provided for destination" }
    /**
     * The destination port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994`. To match with any port, specify `ANY`.
     */
    public val destinationPort: kotlin.String = requireNotNull(builder.destinationPort) { "A non-null value must be provided for destinationPort" }
    /**
     * The direction of traffic flow to inspect. If set to `ANY`, the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to `FORWARD`, the inspection only matches traffic going from the source to the destination.
     */
    public val direction: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleDirection = requireNotNull(builder.direction) { "A non-null value must be provided for direction" }
    /**
     * The protocol to inspect for. To specify all, you can use `IP`, because all traffic on Amazon Web Services and on the internet is IP.
     */
    public val protocol: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleProtocol = requireNotNull(builder.protocol) { "A non-null value must be provided for protocol" }
    /**
     * The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
     *
     * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
     *
     * Examples:
     * + To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32`.
     * + To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
     * + To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
     * + To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
     *
     * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * The source port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994`. To match with any port, specify `ANY`.
     */
    public val sourcePort: kotlin.String = requireNotNull(builder.sourcePort) { "A non-null value must be provided for sourcePort" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.Header = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Header(")
        append("destination=$destination,")
        append("destinationPort=$destinationPort,")
        append("direction=$direction,")
        append("protocol=$protocol,")
        append("source=$source,")
        append("sourcePort=$sourcePort")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination.hashCode()
        result = 31 * result + (destinationPort.hashCode())
        result = 31 * result + (direction.hashCode())
        result = 31 * result + (protocol.hashCode())
        result = 31 * result + (source.hashCode())
        result = 31 * result + (sourcePort.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Header

        if (destination != other.destination) return false
        if (destinationPort != other.destinationPort) return false
        if (direction != other.direction) return false
        if (protocol != other.protocol) return false
        if (source != other.source) return false
        if (sourcePort != other.sourcePort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.Header = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
         *
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
         *
         * Examples:
         * + To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32`.
         * + To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
         * + To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
         * + To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
         *
         * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
         */
        public var destination: kotlin.String? = null
        /**
         * The destination port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994`. To match with any port, specify `ANY`.
         */
        public var destinationPort: kotlin.String? = null
        /**
         * The direction of traffic flow to inspect. If set to `ANY`, the inspection matches bidirectional traffic, both from the source to the destination and from the destination to the source. If set to `FORWARD`, the inspection only matches traffic going from the source to the destination.
         */
        public var direction: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleDirection? = null
        /**
         * The protocol to inspect for. To specify all, you can use `IP`, because all traffic on Amazon Web Services and on the internet is IP.
         */
        public var protocol: aws.sdk.kotlin.services.networkfirewall.model.StatefulRuleProtocol? = null
        /**
         * The source IP address or address range to inspect for, in CIDR notation. To match with any address, specify `ANY`.
         *
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
         *
         * Examples:
         * + To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32`.
         * + To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
         * + To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
         * + To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
         *
         * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
         */
        public var source: kotlin.String? = null
        /**
         * The source port to inspect for. You can specify an individual port, for example `1994` and you can specify a port range, for example `1990:1994`. To match with any port, specify `ANY`.
         */
        public var sourcePort: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.Header) : this() {
            this.destination = x.destination
            this.destinationPort = x.destinationPort
            this.direction = x.direction
            this.protocol = x.protocol
            this.source = x.source
            this.sourcePort = x.sourcePort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.Header = Header(this)

        internal fun correctErrors(): Builder {
            if (destination == null) destination = ""
            if (destinationPort == null) destinationPort = ""
            if (direction == null) direction = StatefulRuleDirection.SdkUnknown("no value provided")
            if (protocol == null) protocol = StatefulRuleProtocol.SdkUnknown("no value provided")
            if (source == null) source = ""
            if (sourcePort == null) sourcePort = ""
            return this
        }
    }
}
