// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Detailed information about the current status of a Firewall. You can retrieve this for a firewall by calling DescribeFirewall and providing the firewall name and ARN.
 */
public class FirewallStatus private constructor(builder: Builder) {
    /**
     * Describes the capacity usage of the resources contained in a firewall's reference sets. Network Firewall calclulates the capacity usage by taking an aggregated count of all of the resources used by all of the reference sets in a firewall.
     */
    public val capacityUsageSummary: aws.sdk.kotlin.services.networkfirewall.model.CapacityUsageSummary? = builder.capacityUsageSummary
    /**
     * The configuration sync state for the firewall. This summarizes the sync states reported in the `Config` settings for all of the Availability Zones where you have configured the firewall.
     *
     * When you create a firewall or update its configuration, for example by adding a rule group to its firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This summary indicates whether the configuration changes have been applied everywhere.
     *
     * This status must be `IN_SYNC` for the firewall to be ready for use, but it doesn't indicate that the firewall is ready. The `Status` setting indicates firewall readiness.
     */
    public val configurationSyncStateSummary: aws.sdk.kotlin.services.networkfirewall.model.ConfigurationSyncState = requireNotNull(builder.configurationSyncStateSummary) { "A non-null value must be provided for configurationSyncStateSummary" }
    /**
     * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you've configured it. This setting is `READY` only when the `ConfigurationSyncStateSummary` value is `IN_SYNC` and the `Attachment``Status` values for all of the configured subnets are `READY`.
     */
    public val status: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatusValue = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The subnets that you've configured for use by the Network Firewall firewall. This contains one array element per Availability Zone where you've configured a subnet. These objects provide details of the information that is summarized in the `ConfigurationSyncStateSummary` and `Status`, broken down by zone and configuration object.
     */
    public val syncStates: Map<String, SyncState>? = builder.syncStates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallStatus(")
        append("capacityUsageSummary=$capacityUsageSummary,")
        append("configurationSyncStateSummary=$configurationSyncStateSummary,")
        append("status=$status,")
        append("syncStates=$syncStates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityUsageSummary?.hashCode() ?: 0
        result = 31 * result + (configurationSyncStateSummary.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (syncStates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallStatus

        if (capacityUsageSummary != other.capacityUsageSummary) return false
        if (configurationSyncStateSummary != other.configurationSyncStateSummary) return false
        if (status != other.status) return false
        if (syncStates != other.syncStates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes the capacity usage of the resources contained in a firewall's reference sets. Network Firewall calclulates the capacity usage by taking an aggregated count of all of the resources used by all of the reference sets in a firewall.
         */
        public var capacityUsageSummary: aws.sdk.kotlin.services.networkfirewall.model.CapacityUsageSummary? = null
        /**
         * The configuration sync state for the firewall. This summarizes the sync states reported in the `Config` settings for all of the Availability Zones where you have configured the firewall.
         *
         * When you create a firewall or update its configuration, for example by adding a rule group to its firewall policy, Network Firewall distributes the configuration changes to all zones where the firewall is in use. This summary indicates whether the configuration changes have been applied everywhere.
         *
         * This status must be `IN_SYNC` for the firewall to be ready for use, but it doesn't indicate that the firewall is ready. The `Status` setting indicates firewall readiness.
         */
        public var configurationSyncStateSummary: aws.sdk.kotlin.services.networkfirewall.model.ConfigurationSyncState? = null
        /**
         * The readiness of the configured firewall to handle network traffic across all of the Availability Zones where you've configured it. This setting is `READY` only when the `ConfigurationSyncStateSummary` value is `IN_SYNC` and the `Attachment``Status` values for all of the configured subnets are `READY`.
         */
        public var status: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatusValue? = null
        /**
         * The subnets that you've configured for use by the Network Firewall firewall. This contains one array element per Availability Zone where you've configured a subnet. These objects provide details of the information that is summarized in the `ConfigurationSyncStateSummary` and `Status`, broken down by zone and configuration object.
         */
        public var syncStates: Map<String, SyncState>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus) : this() {
            this.capacityUsageSummary = x.capacityUsageSummary
            this.configurationSyncStateSummary = x.configurationSyncStateSummary
            this.status = x.status
            this.syncStates = x.syncStates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus = FirewallStatus(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.CapacityUsageSummary] inside the given [block]
         */
        public fun capacityUsageSummary(block: aws.sdk.kotlin.services.networkfirewall.model.CapacityUsageSummary.Builder.() -> kotlin.Unit) {
            this.capacityUsageSummary = aws.sdk.kotlin.services.networkfirewall.model.CapacityUsageSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (configurationSyncStateSummary == null) configurationSyncStateSummary = ConfigurationSyncState.SdkUnknown("no value provided")
            if (status == null) status = FirewallStatusValue.SdkUnknown("no value provided")
            return this
        }
    }
}
