// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class CreateTlsInspectionConfigurationRequest private constructor(builder: Builder) {
    /**
     * A description of the TLS inspection configuration.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A complex type that contains optional Amazon Web Services Key Management Service (KMS) encryption settings for your Network Firewall resources. Your data is encrypted by default with an Amazon Web Services owned key that Amazon Web Services owns and manages for you. You can use either the Amazon Web Services owned key, or provide your own customer managed key. To learn more about KMS encryption of your Network Firewall resources, see [Encryption at rest with Amazon Web Services Key Managment Service](https://docs.aws.amazon.com/kms/latest/developerguide/kms-encryption-at-rest.html) in the *Network Firewall Developer Guide*.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
     *
     * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
     *
     * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
     */
    public val tlsInspectionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration? = builder.tlsInspectionConfiguration
    /**
     * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection configuration after you create it.
     */
    public val tlsInspectionConfigurationName: kotlin.String? = builder.tlsInspectionConfigurationName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTlsInspectionConfigurationRequest(")
        append("description=$description,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("tags=$tags,")
        append("tlsInspectionConfiguration=$tlsInspectionConfiguration,")
        append("tlsInspectionConfigurationName=$tlsInspectionConfigurationName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tlsInspectionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tlsInspectionConfigurationName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTlsInspectionConfigurationRequest

        if (description != other.description) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (tags != other.tags) return false
        if (tlsInspectionConfiguration != other.tlsInspectionConfiguration) return false
        if (tlsInspectionConfigurationName != other.tlsInspectionConfigurationName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the TLS inspection configuration.
         */
        public var description: kotlin.String? = null
        /**
         * A complex type that contains optional Amazon Web Services Key Management Service (KMS) encryption settings for your Network Firewall resources. Your data is encrypted by default with an Amazon Web Services owned key that Amazon Web Services owns and manages for you. You can use either the Amazon Web Services owned key, or provide your own customer managed key. To learn more about KMS encryption of your Network Firewall resources, see [Encryption at rest with Amazon Web Services Key Managment Service](https://docs.aws.amazon.com/kms/latest/developerguide/kms-encryption-at-rest.html) in the *Network Firewall Developer Guide*.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
         *
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
         *
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect the traffic traveling through your firewalls. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Inspecting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
         */
        public var tlsInspectionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration? = null
        /**
         * The descriptive name of the TLS inspection configuration. You can't change the name of a TLS inspection configuration after you create it.
         */
        public var tlsInspectionConfigurationName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest) : this() {
            this.description = x.description
            this.encryptionConfiguration = x.encryptionConfiguration
            this.tags = x.tags
            this.tlsInspectionConfiguration = x.tlsInspectionConfiguration
            this.tlsInspectionConfigurationName = x.tlsInspectionConfigurationName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CreateTlsInspectionConfigurationRequest = CreateTlsInspectionConfigurationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration] inside the given [block]
         */
        public fun tlsInspectionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration.Builder.() -> kotlin.Unit) {
            this.tlsInspectionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
