// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class CreateRuleGroupRequest private constructor(builder: Builder) {
    /**
     * Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule behavior such as asymmetric routing. If set to `TRUE`, Network Firewall runs the analysis and then creates the rule group for you. To run the stateless rule group analyzer without creating the rule group, set `DryRun` to `TRUE`.
     */
    public val analyzeRuleGroup: kotlin.Boolean? = builder.analyzeRuleGroup
    /**
     * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
     *
     * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with `DryRun` set to `TRUE`.
     *
     * You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to grow.
     *
     * **Capacity for a stateless rule group**
     *
     * For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group.
     *
     * To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule's match settings:
     * + A match setting with no criteria specified has a value of 1.
     * + A match setting with `Any` specified has a value of 1.
     * + All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting &#91;"UDP"&#93; and a source setting &#91;"10.0.0.0/24"&#93; each have a value of 1. A protocol setting &#91;"UDP","TCP"&#93; has a value of 2. A source setting &#91;"10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"&#93; has a value of 3.
     *
     * A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting &#91;"UDP","TCP"&#93;, source setting &#91;"10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"&#93;, and a single specification or no specification for each of the other match settings has a capacity requirement of 6.
     *
     * **Capacity for a stateful rule group**
     *
     * For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group.
     */
    public val capacity: kotlin.Int? = builder.capacity
    /**
     * A description of the rule group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
     *
     * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
     *
     * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A complex type that contains settings for encryption of your rule group resources.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * An object that defines the rule group rules.
     *
     * You must provide either this rule group setting or a `Rules` setting, but not both.
     */
    public val ruleGroup: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup? = builder.ruleGroup
    /**
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     */
    public val ruleGroupName: kotlin.String? = builder.ruleGroupName
    /**
     * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups.
     *
     * You must provide either this rules setting or a populated `RuleGroup` setting, but not both.
     *
     * You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a RuleGroup object that Network Firewall has populated from your string.
     */
    public val rules: kotlin.String? = builder.rules
    /**
     * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to keep track of updates made to the originating rule group.
     */
    public val sourceMetadata: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata? = builder.sourceMetadata
    /**
     * The key:value pairs to associate with the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
     */
    public val type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRuleGroupRequest(")
        append("analyzeRuleGroup=$analyzeRuleGroup,")
        append("capacity=$capacity,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("ruleGroup=$ruleGroup,")
        append("ruleGroupName=$ruleGroupName,")
        append("rules=$rules,")
        append("sourceMetadata=$sourceMetadata,")
        append("tags=$tags,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyzeRuleGroup?.hashCode() ?: 0
        result = 31 * result + (capacity ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ruleGroup?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupName?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (sourceMetadata?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRuleGroupRequest

        if (analyzeRuleGroup != other.analyzeRuleGroup) return false
        if (capacity != other.capacity) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (ruleGroup != other.ruleGroup) return false
        if (ruleGroupName != other.ruleGroupName) return false
        if (rules != other.rules) return false
        if (sourceMetadata != other.sourceMetadata) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether you want Network Firewall to analyze the stateless rules in the rule group for rule behavior such as asymmetric routing. If set to `TRUE`, Network Firewall runs the analysis and then creates the rule group for you. To run the stateless rule group analyzer without creating the rule group, set `DryRun` to `TRUE`.
         */
        public var analyzeRuleGroup: kotlin.Boolean? = null
        /**
         * The maximum operating resources that this rule group can use. Rule group capacity is fixed at creation. When you update a rule group, you are limited to this capacity. When you reference a rule group from a firewall policy, Network Firewall reserves this capacity for the rule group.
         *
         * You can retrieve the capacity that would be required for a rule group before you create the rule group by calling CreateRuleGroup with `DryRun` set to `TRUE`.
         *
         * You can't change or exceed this capacity when you update the rule group, so leave room for your rule group to grow.
         *
         * **Capacity for a stateless rule group**
         *
         * For a stateless rule group, the capacity required is the sum of the capacity requirements of the individual rules that you expect to have in the rule group.
         *
         * To calculate the capacity requirement of a single rule, multiply the capacity requirement values of each of the rule's match settings:
         * + A match setting with no criteria specified has a value of 1.
         * + A match setting with `Any` specified has a value of 1.
         * + All other match settings have a value equal to the number of elements provided in the setting. For example, a protocol setting &#91;"UDP"&#93; and a source setting &#91;"10.0.0.0/24"&#93; each have a value of 1. A protocol setting &#91;"UDP","TCP"&#93; has a value of 2. A source setting &#91;"10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"&#93; has a value of 3.
         *
         * A rule with no criteria specified in any of its match settings has a capacity requirement of 1. A rule with protocol setting &#91;"UDP","TCP"&#93;, source setting &#91;"10.0.0.0/24","10.0.0.1/24","10.0.0.2/24"&#93;, and a single specification or no specification for each of the other match settings has a capacity requirement of 6.
         *
         * **Capacity for a stateful rule group**
         *
         * For a stateful rule group, the minimum capacity required is the number of individual rules that you expect to have in the rule group.
         */
        public var capacity: kotlin.Int? = null
        /**
         * A description of the rule group.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
         *
         * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
         *
         * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A complex type that contains settings for encryption of your rule group resources.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * An object that defines the rule group rules.
         *
         * You must provide either this rule group setting or a `Rules` setting, but not both.
         */
        public var ruleGroup: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup? = null
        /**
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         */
        public var ruleGroupName: kotlin.String? = null
        /**
         * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups.
         *
         * You must provide either this rules setting or a populated `RuleGroup` setting, but not both.
         *
         * You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a RuleGroup object that Network Firewall has populated from your string.
         */
        public var rules: kotlin.String? = null
        /**
         * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to keep track of updates made to the originating rule group.
         */
        public var sourceMetadata: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata? = null
        /**
         * The key:value pairs to associate with the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
         */
        public var type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupRequest) : this() {
            this.analyzeRuleGroup = x.analyzeRuleGroup
            this.capacity = x.capacity
            this.description = x.description
            this.dryRun = x.dryRun
            this.encryptionConfiguration = x.encryptionConfiguration
            this.ruleGroup = x.ruleGroup
            this.ruleGroupName = x.ruleGroupName
            this.rules = x.rules
            this.sourceMetadata = x.sourceMetadata
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CreateRuleGroupRequest = CreateRuleGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.RuleGroup] inside the given [block]
         */
        public fun ruleGroup(block: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup.Builder.() -> kotlin.Unit) {
            this.ruleGroup = aws.sdk.kotlin.services.networkfirewall.model.RuleGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata] inside the given [block]
         */
        public fun sourceMetadata(block: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata.Builder.() -> kotlin.Unit) {
            this.sourceMetadata = aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
