// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.serde

import aws.sdk.kotlin.services.networkfirewall.model.DeleteTlsInspectionConfigurationResponse
import aws.sdk.kotlin.services.networkfirewall.model.NetworkFirewallException
import aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteTLSInspectionConfigurationOperationDeserializer: HttpDeserialize<DeleteTlsInspectionConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteTlsInspectionConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteTlsInspectionConfigurationError(context, call)
        }
        val builder = DeleteTlsInspectionConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteTLSInspectionConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteTlsInspectionConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw NetworkFirewallException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> NetworkFirewallException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteTLSInspectionConfigurationOperationBody(builder: DeleteTlsInspectionConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TLSINSPECTIONCONFIGURATIONRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TLSInspectionConfigurationResponse"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TLSINSPECTIONCONFIGURATIONRESPONSE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TLSINSPECTIONCONFIGURATIONRESPONSE_DESCRIPTOR.index -> builder.tlsInspectionConfigurationResponse = deserializeTlsInspectionConfigurationResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
