// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Settings that define the Secure Sockets Layer/Transport Layer Security (SSL/TLS) traffic that Network Firewall should decrypt for inspection by the stateful rule engine.
 */
public class ServerCertificateScope private constructor(builder: Builder) {
    /**
     * The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any destination port.
     *
     * You can specify individual ports, for example `1994`, and you can specify port ranges, such as `1990:1994`.
     */
    public val destinationPorts: List<PortRange>? = builder.destinationPorts
    /**
     * The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this matches with any destination address.
     */
    public val destinations: List<Address>? = builder.destinations
    /**
     * The protocols to decrypt for inspection, specified using each protocol's assigned internet protocol number (IANA). Network Firewall currently supports only TCP.
     */
    public val protocols: List<Int>? = builder.protocols
    /**
     * The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any source port.
     *
     * You can specify individual ports, for example `1994`, and you can specify port ranges, such as `1990:1994`.
     */
    public val sourcePorts: List<PortRange>? = builder.sourcePorts
    /**
     * The source IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this matches with any source address.
     */
    public val sources: List<Address>? = builder.sources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateScope = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerCertificateScope(")
        append("destinationPorts=$destinationPorts,")
        append("destinations=$destinations,")
        append("protocols=$protocols,")
        append("sourcePorts=$sourcePorts,")
        append("sources=$sources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationPorts?.hashCode() ?: 0
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (sourcePorts?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerCertificateScope

        if (destinationPorts != other.destinationPorts) return false
        if (destinations != other.destinations) return false
        if (protocols != other.protocols) return false
        if (sourcePorts != other.sourcePorts) return false
        if (sources != other.sources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateScope = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The destination ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any destination port.
         *
         * You can specify individual ports, for example `1994`, and you can specify port ranges, such as `1990:1994`.
         */
        public var destinationPorts: List<PortRange>? = null
        /**
         * The destination IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this matches with any destination address.
         */
        public var destinations: List<Address>? = null
        /**
         * The protocols to decrypt for inspection, specified using each protocol's assigned internet protocol number (IANA). Network Firewall currently supports only TCP.
         */
        public var protocols: List<Int>? = null
        /**
         * The source ports to decrypt for inspection, in Transmission Control Protocol (TCP) format. If not specified, this matches with any source port.
         *
         * You can specify individual ports, for example `1994`, and you can specify port ranges, such as `1990:1994`.
         */
        public var sourcePorts: List<PortRange>? = null
        /**
         * The source IP addresses and address ranges to decrypt for inspection, in CIDR notation. If not specified, this matches with any source address.
         */
        public var sources: List<Address>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateScope) : this() {
            this.destinationPorts = x.destinationPorts
            this.destinations = x.destinations
            this.protocols = x.protocols
            this.sourcePorts = x.sourcePorts
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateScope = ServerCertificateScope(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
