// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The inspection criteria and action for a single stateless rule. Network Firewall inspects each packet for the specified matching criteria. When a packet matches the criteria, Network Firewall performs the rule's actions on the packet.
 */
public class RuleDefinition private constructor(builder: Builder) {
    /**
     * The actions to take on a packet that matches one of the stateless rule definition's match attributes. You must specify a standard action and you can add custom actions.
     *
     * Network Firewall only forwards a packet for stateful rule inspection if you specify `aws:forward_to_sfe` for a rule that the packet matches, or if the packet doesn't match any stateless rule and you specify `aws:forward_to_sfe` for the `StatelessDefaultActions` setting for the FirewallPolicy.
     *
     * For every rule, you must specify exactly one of the following standard actions.
     * + **aws:pass** - Discontinues all inspection of the packet and permits it to go to its intended destination.
     * + **aws:drop** - Discontinues all inspection of the packet and blocks it from going to its intended destination.
     * + **aws:forward_to_sfe** - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection.
     *
     * Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you've assigned to the action in this `Actions` setting. For information about the options, see CustomAction.
     *
     * To provide more than one action in this setting, separate the settings with a comma. For example, if you have a custom `PublishMetrics` action that you've named `MyMetricsAction`, then you could specify the standard action `aws:pass` and the custom action with `[“aws:pass”, “MyMetricsAction”]`.
     */
    public val actions: List<String> = requireNotNull(builder.actions) { "A non-null value must be provided for actions" }
    /**
     * Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
     */
    public val matchAttributes: aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes? = builder.matchAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleDefinition(")
        append("actions=$actions,")
        append("matchAttributes=$matchAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions.hashCode()
        result = 31 * result + (matchAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleDefinition

        if (actions != other.actions) return false
        if (matchAttributes != other.matchAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions to take on a packet that matches one of the stateless rule definition's match attributes. You must specify a standard action and you can add custom actions.
         *
         * Network Firewall only forwards a packet for stateful rule inspection if you specify `aws:forward_to_sfe` for a rule that the packet matches, or if the packet doesn't match any stateless rule and you specify `aws:forward_to_sfe` for the `StatelessDefaultActions` setting for the FirewallPolicy.
         *
         * For every rule, you must specify exactly one of the following standard actions.
         * + **aws:pass** - Discontinues all inspection of the packet and permits it to go to its intended destination.
         * + **aws:drop** - Discontinues all inspection of the packet and blocks it from going to its intended destination.
         * + **aws:forward_to_sfe** - Discontinues stateless inspection of the packet and forwards it to the stateful rule engine for inspection.
         *
         * Additionally, you can specify a custom action. To do this, you define a custom action by name and type, then provide the name you've assigned to the action in this `Actions` setting. For information about the options, see CustomAction.
         *
         * To provide more than one action in this setting, separate the settings with a comma. For example, if you have a custom `PublishMetrics` action that you've named `MyMetricsAction`, then you could specify the standard action `aws:pass` and the custom action with `[“aws:pass”, “MyMetricsAction”]`.
         */
        public var actions: List<String>? = null
        /**
         * Criteria for Network Firewall to use to inspect an individual packet in stateless rule inspection. Each match attributes set can include one or more items such as IP address, CIDR range, port number, protocol, and TCP flags.
         */
        public var matchAttributes: aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition) : this() {
            this.actions = x.actions
            this.matchAttributes = x.matchAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.RuleDefinition = RuleDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes] inside the given [block]
         */
        public fun matchAttributes(block: aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes.Builder.() -> kotlin.Unit) {
            this.matchAttributes = aws.sdk.kotlin.services.networkfirewall.model.MatchAttributes.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (actions == null) actions = emptyList()
            return this
        }
    }
}
