// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class DescribeTlsInspectionConfigurationResponse private constructor(builder: Builder) {
    /**
     * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
     *
     * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
     *
     * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Decrypting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
     */
    public val tlsInspectionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration? = builder.tlsInspectionConfiguration
    /**
     * The high-level properties of a TLS inspection configuration. This, along with the TLSInspectionConfiguration, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
     */
    public val tlsInspectionConfigurationResponse: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse? = builder.tlsInspectionConfigurationResponse
    /**
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request.
     *
     * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public val updateToken: kotlin.String = requireNotNull(builder.updateToken) { "A non-null value must be provided for updateToken" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTlsInspectionConfigurationResponse(")
        append("tlsInspectionConfiguration=$tlsInspectionConfiguration,")
        append("tlsInspectionConfigurationResponse=$tlsInspectionConfigurationResponse,")
        append("updateToken=$updateToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = tlsInspectionConfiguration?.hashCode() ?: 0
        result = 31 * result + (tlsInspectionConfigurationResponse?.hashCode() ?: 0)
        result = 31 * result + (updateToken.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTlsInspectionConfigurationResponse

        if (tlsInspectionConfiguration != other.tlsInspectionConfiguration) return false
        if (tlsInspectionConfigurationResponse != other.tlsInspectionConfigurationResponse) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
         *
         * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
         *
         * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Decrypting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
         */
        public var tlsInspectionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration? = null
        /**
         * The high-level properties of a TLS inspection configuration. This, along with the TLSInspectionConfiguration, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
         */
        public var tlsInspectionConfigurationResponse: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse? = null
        /**
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the TLS inspection configuration. The token marks the state of the TLS inspection configuration resource at the time of the request.
         *
         * To make changes to the TLS inspection configuration, you provide the token in your request. Network Firewall uses the token to ensure that the TLS inspection configuration hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the TLS inspection configuration again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
         */
        public var updateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse) : this() {
            this.tlsInspectionConfiguration = x.tlsInspectionConfiguration
            this.tlsInspectionConfigurationResponse = x.tlsInspectionConfigurationResponse
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.DescribeTlsInspectionConfigurationResponse = DescribeTlsInspectionConfigurationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration] inside the given [block]
         */
        public fun tlsInspectionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration.Builder.() -> kotlin.Unit) {
            this.tlsInspectionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse] inside the given [block]
         */
        public fun tlsInspectionConfigurationResponse(block: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse.Builder.() -> kotlin.Unit) {
            this.tlsInspectionConfigurationResponse = aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationResponse.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (updateToken == null) updateToken = ""
            return this
        }
    }
}
