// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Summarizes the CIDR blocks used by the IP set references in a firewall. Network Firewall calculates the number of CIDRs by taking an aggregated count of all CIDRs used by the IP sets you are referencing.
 */
public class CidrSummary private constructor(builder: Builder) {
    /**
     * The number of CIDR blocks available for use by the IP set references in a firewall.
     */
    public val availableCidrCount: kotlin.Int? = builder.availableCidrCount
    /**
     * The list of the IP set references used by a firewall.
     */
    public val ipSetReferences: Map<String, IpSetMetadata>? = builder.ipSetReferences
    /**
     * The number of CIDR blocks used by the IP set references in a firewall.
     */
    public val utilizedCidrCount: kotlin.Int? = builder.utilizedCidrCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CidrSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CidrSummary(")
        append("availableCidrCount=$availableCidrCount,")
        append("ipSetReferences=$ipSetReferences,")
        append("utilizedCidrCount=$utilizedCidrCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableCidrCount ?: 0
        result = 31 * result + (ipSetReferences?.hashCode() ?: 0)
        result = 31 * result + (utilizedCidrCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CidrSummary

        if (availableCidrCount != other.availableCidrCount) return false
        if (ipSetReferences != other.ipSetReferences) return false
        if (utilizedCidrCount != other.utilizedCidrCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CidrSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of CIDR blocks available for use by the IP set references in a firewall.
         */
        public var availableCidrCount: kotlin.Int? = null
        /**
         * The list of the IP set references used by a firewall.
         */
        public var ipSetReferences: Map<String, IpSetMetadata>? = null
        /**
         * The number of CIDR blocks used by the IP set references in a firewall.
         */
        public var utilizedCidrCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CidrSummary) : this() {
            this.availableCidrCount = x.availableCidrCount
            this.ipSetReferences = x.ipSetReferences
            this.utilizedCidrCount = x.utilizedCidrCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CidrSummary = CidrSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
