// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * A single IP address specification. This is used in the MatchAttributes source and destination specifications.
 */
public class Address private constructor(builder: Builder) {
    /**
     * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
     *
     * Examples:
     * + To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32`.
     * + To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
     * + To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
     * + To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
     *
     * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
     */
    public val addressDefinition: kotlin.String = requireNotNull(builder.addressDefinition) { "A non-null value must be provided for addressDefinition" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.Address = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Address(")
        append("addressDefinition=$addressDefinition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressDefinition.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Address

        if (addressDefinition != other.addressDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.Address = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify an IP address or a block of IP addresses in Classless Inter-Domain Routing (CIDR) notation. Network Firewall supports all address ranges for IPv4 and IPv6.
         *
         * Examples:
         * + To configure Network Firewall to inspect for the IP address 192.0.2.44, specify `192.0.2.44/32`.
         * + To configure Network Firewall to inspect for IP addresses from 192.0.2.0 to 192.0.2.255, specify `192.0.2.0/24`.
         * + To configure Network Firewall to inspect for the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify `1111:0000:0000:0000:0000:0000:0000:0111/128`.
         * + To configure Network Firewall to inspect for IP addresses from 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify `1111:0000:0000:0000:0000:0000:0000:0000/64`.
         *
         * For more information about CIDR notation, see the Wikipedia entry [Classless Inter-Domain Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
         */
        public var addressDefinition: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.Address) : this() {
            this.addressDefinition = x.addressDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.Address = Address(this)

        internal fun correctErrors(): Builder {
            if (addressDefinition == null) addressDefinition = ""
            return this
        }
    }
}
