// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class UpdateRuleGroupRequest private constructor(builder: Builder) {
    /**
     * A description of the rule group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
     *
     * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
     *
     * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
     */
    public val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * A complex type that contains settings for encryption of your rule group resources.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * An object that defines the rule group rules.
     *
     * You must provide either this rule group setting or a `Rules` setting, but not both.
     */
    public val ruleGroup: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup? = builder.ruleGroup
    /**
     * The Amazon Resource Name (ARN) of the rule group.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    public val ruleGroupArn: kotlin.String? = builder.ruleGroupArn
    /**
     * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
     *
     * You must specify the ARN or the name, and you can specify both.
     */
    public val ruleGroupName: kotlin.String? = builder.ruleGroupName
    /**
     * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups.
     *
     * You must provide either this rules setting or a populated `RuleGroup` setting, but not both.
     *
     * You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a RuleGroup object that Network Firewall has populated from your string.
     */
    public val rules: kotlin.String? = builder.rules
    /**
     * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to keep track of updates made to the originating rule group.
     */
    public val sourceMetadata: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata? = builder.sourceMetadata
    /**
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
     *
     * This setting is required for requests that do not include the `RuleGroupARN`.
     */
    public val type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = builder.type
    /**
     * A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request.
     *
     * To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public val updateToken: kotlin.String? = builder.updateToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRuleGroupRequest(")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("ruleGroup=$ruleGroup,")
        append("ruleGroupArn=$ruleGroupArn,")
        append("ruleGroupName=$ruleGroupName,")
        append("rules=$rules,")
        append("sourceMetadata=$sourceMetadata,")
        append("type=$type,")
        append("updateToken=$updateToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ruleGroup?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupArn?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupName?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (sourceMetadata?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRuleGroupRequest

        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (ruleGroup != other.ruleGroup) return false
        if (ruleGroupArn != other.ruleGroupArn) return false
        if (ruleGroupName != other.ruleGroupName) return false
        if (rules != other.rules) return false
        if (sourceMetadata != other.sourceMetadata) return false
        if (type != other.type) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the rule group.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether you want Network Firewall to just check the validity of the request, rather than run the request.
         *
         * If set to `TRUE`, Network Firewall checks whether the request can run successfully, but doesn't actually make the requested changes. The call returns the value that the request would return if you ran it with dry run set to `FALSE`, but doesn't make additions or changes to your resources. This option allows you to make sure that you have the required permissions to run the request and that your request parameters are valid.
         *
         * If set to `FALSE`, Network Firewall makes the requested changes to your resources.
         */
        public var dryRun: kotlin.Boolean? = null
        /**
         * A complex type that contains settings for encryption of your rule group resources.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration? = null
        /**
         * An object that defines the rule group rules.
         *
         * You must provide either this rule group setting or a `Rules` setting, but not both.
         */
        public var ruleGroup: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup? = null
        /**
         * The Amazon Resource Name (ARN) of the rule group.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        public var ruleGroupArn: kotlin.String? = null
        /**
         * The descriptive name of the rule group. You can't change the name of a rule group after you create it.
         *
         * You must specify the ARN or the name, and you can specify both.
         */
        public var ruleGroupName: kotlin.String? = null
        /**
         * A string containing stateful rule group rules specifications in Suricata flat format, with one rule per line. Use this to import your existing Suricata compatible rule groups.
         *
         * You must provide either this rules setting or a populated `RuleGroup` setting, but not both.
         *
         * You can provide your rule group specification in Suricata flat format through this setting when you create or update your rule group. The call response returns a RuleGroup object that Network Firewall has populated from your string.
         */
        public var rules: kotlin.String? = null
        /**
         * A complex type that contains metadata about the rule group that your own rule group is copied from. You can use the metadata to keep track of updates made to the originating rule group.
         */
        public var sourceMetadata: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata? = null
        /**
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
         *
         * This setting is required for requests that do not include the `RuleGroupARN`.
         */
        public var type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = null
        /**
         * A token used for optimistic locking. Network Firewall returns a token to your requests that access the rule group. The token marks the state of the rule group resource at the time of the request.
         *
         * To make changes to the rule group, you provide the token in your request. Network Firewall uses the token to ensure that the rule group hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the rule group again to get a current copy of it with a current token. Reapply your changes as needed, then try the operation again using the new token.
         */
        public var updateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupRequest) : this() {
            this.description = x.description
            this.dryRun = x.dryRun
            this.encryptionConfiguration = x.encryptionConfiguration
            this.ruleGroup = x.ruleGroup
            this.ruleGroupArn = x.ruleGroupArn
            this.ruleGroupName = x.ruleGroupName
            this.rules = x.rules
            this.sourceMetadata = x.sourceMetadata
            this.type = x.type
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.UpdateRuleGroupRequest = UpdateRuleGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.networkfirewall.model.EncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.RuleGroup] inside the given [block]
         */
        public fun ruleGroup(block: aws.sdk.kotlin.services.networkfirewall.model.RuleGroup.Builder.() -> kotlin.Unit) {
            this.ruleGroup = aws.sdk.kotlin.services.networkfirewall.model.RuleGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata] inside the given [block]
         */
        public fun sourceMetadata(block: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata.Builder.() -> kotlin.Unit) {
            this.sourceMetadata = aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
