// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The object that defines a TLS inspection configuration. This, along with TLSInspectionConfigurationResponse, define the TLS inspection configuration. You can retrieve all objects for a TLS inspection configuration by calling DescribeTLSInspectionConfiguration.
 *
 * Network Firewall uses a TLS inspection configuration to decrypt traffic. Network Firewall re-encrypts the traffic before sending it to its destination.
 *
 * To use a TLS inspection configuration, you add it to a new Network Firewall firewall policy, then you apply the firewall policy to a firewall. Network Firewall acts as a proxy service to decrypt and inspect inbound traffic. You can reference a TLS inspection configuration from more than one firewall policy, and you can use a firewall policy in more than one firewall. For more information about using TLS inspection configurations, see [Decrypting SSL/TLS traffic with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection.html) in the *Network Firewall Developer Guide*.
 */
public class TlsInspectionConfiguration private constructor(builder: Builder) {
    /**
     * Lists the server certificate configurations that are associated with the TLS configuration.
     */
    public val serverCertificateConfigurations: List<ServerCertificateConfiguration>? = builder.serverCertificateConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TlsInspectionConfiguration(")
        append("serverCertificateConfigurations=$serverCertificateConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = serverCertificateConfigurations?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TlsInspectionConfiguration

        if (serverCertificateConfigurations != other.serverCertificateConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Lists the server certificate configurations that are associated with the TLS configuration.
         */
        public var serverCertificateConfigurations: List<ServerCertificateConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration) : this() {
            this.serverCertificateConfigurations = x.serverCertificateConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfiguration = TlsInspectionConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
