// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class DescribeFirewallResponse private constructor(builder: Builder) {
    /**
     * The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints.
     */
    public val firewall: aws.sdk.kotlin.services.networkfirewall.model.Firewall? = builder.firewall
    /**
     * Detailed information about the current status of a Firewall. You can retrieve this for a firewall by calling DescribeFirewall and providing the firewall name and ARN.
     */
    public val firewallStatus: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus? = builder.firewallStatus
    /**
     * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.
     *
     * To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.
     *
     * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public val updateToken: kotlin.String? = builder.updateToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeFirewallResponse(")
        append("firewall=$firewall,")
        append("firewallStatus=$firewallStatus,")
        append("updateToken=$updateToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firewall?.hashCode() ?: 0
        result = 31 * result + (firewallStatus?.hashCode() ?: 0)
        result = 31 * result + (updateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeFirewallResponse

        if (firewall != other.firewall) return false
        if (firewallStatus != other.firewallStatus) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration settings for the firewall. These settings include the firewall policy and the subnets in your VPC to use for the firewall endpoints.
         */
        public var firewall: aws.sdk.kotlin.services.networkfirewall.model.Firewall? = null
        /**
         * Detailed information about the current status of a Firewall. You can retrieve this for a firewall by calling DescribeFirewall and providing the firewall name and ARN.
         */
        public var firewallStatus: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus? = null
        /**
         * An optional token that you can use for optimistic locking. Network Firewall returns a token to your requests that access the firewall. The token marks the state of the firewall resource at the time of the request.
         *
         * To make an unconditional change to the firewall, omit the token in your update request. Without the token, Network Firewall performs your updates regardless of whether the firewall has changed since you last retrieved it.
         *
         * To make a conditional change to the firewall, provide the token in your update request. Network Firewall uses the token to ensure that the firewall hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the firewall again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
         */
        public var updateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallResponse) : this() {
            this.firewall = x.firewall
            this.firewallStatus = x.firewallStatus
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.DescribeFirewallResponse = DescribeFirewallResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.Firewall] inside the given [block]
         */
        public fun firewall(block: aws.sdk.kotlin.services.networkfirewall.model.Firewall.Builder.() -> kotlin.Unit) {
            this.firewall = aws.sdk.kotlin.services.networkfirewall.model.Firewall.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus] inside the given [block]
         */
        public fun firewallStatus(block: aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus.Builder.() -> kotlin.Unit) {
            this.firewallStatus = aws.sdk.kotlin.services.networkfirewall.model.FirewallStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
