// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.paginators

import aws.sdk.kotlin.services.networkfirewall.NetworkFirewallClient
import aws.sdk.kotlin.services.networkfirewall.model.FirewallMetadata
import aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicyMetadata
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallPoliciesResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.networkfirewall.model.ListTlsInspectionConfigurationsRequest
import aws.sdk.kotlin.services.networkfirewall.model.ListTlsInspectionConfigurationsResponse
import aws.sdk.kotlin.services.networkfirewall.model.RuleGroupMetadata
import aws.sdk.kotlin.services.networkfirewall.model.Tag
import aws.sdk.kotlin.services.networkfirewall.model.TlsInspectionConfigurationMetadata
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListFirewallPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallPoliciesResponse]
 */
public fun NetworkFirewallClient.listFirewallPoliciesPaginated(initialRequest: ListFirewallPoliciesRequest = ListFirewallPoliciesRequest { }): Flow<ListFirewallPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallPoliciesPaginated.listFirewallPolicies(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallPoliciesResponse]
 */
public fun NetworkFirewallClient.listFirewallPoliciesPaginated(block: ListFirewallPoliciesRequest.Builder.() -> Unit): Flow<ListFirewallPoliciesResponse> =
    listFirewallPoliciesPaginated(ListFirewallPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallPoliciesPaginated]
 * to access the nested member [FirewallPolicyMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallPolicyMetadata]
 */
@JvmName("listFirewallPoliciesResponseFirewallPolicyMetadata")
public fun Flow<ListFirewallPoliciesResponse>.firewallPolicies(): Flow<FirewallPolicyMetadata> =
    transform() { response ->
        response.firewallPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFirewallsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFirewallsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallsResponse]
 */
public fun NetworkFirewallClient.listFirewallsPaginated(initialRequest: ListFirewallsRequest = ListFirewallsRequest { }): Flow<ListFirewallsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFirewallsPaginated.listFirewalls(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFirewallsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFirewallsResponse]
 */
public fun NetworkFirewallClient.listFirewallsPaginated(block: ListFirewallsRequest.Builder.() -> Unit): Flow<ListFirewallsResponse> =
    listFirewallsPaginated(ListFirewallsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFirewallsPaginated]
 * to access the nested member [FirewallMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FirewallMetadata]
 */
@JvmName("listFirewallsResponseFirewallMetadata")
public fun Flow<ListFirewallsResponse>.firewalls(): Flow<FirewallMetadata> =
    transform() { response ->
        response.firewalls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRuleGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleGroupsResponse]
 */
public fun NetworkFirewallClient.listRuleGroupsPaginated(initialRequest: ListRuleGroupsRequest = ListRuleGroupsRequest { }): Flow<ListRuleGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRuleGroupsPaginated.listRuleGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRuleGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRuleGroupsResponse]
 */
public fun NetworkFirewallClient.listRuleGroupsPaginated(block: ListRuleGroupsRequest.Builder.() -> Unit): Flow<ListRuleGroupsResponse> =
    listRuleGroupsPaginated(ListRuleGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRuleGroupsPaginated]
 * to access the nested member [RuleGroupMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RuleGroupMetadata]
 */
@JvmName("listRuleGroupsResponseRuleGroupMetadata")
public fun Flow<ListRuleGroupsResponse>.ruleGroups(): Flow<RuleGroupMetadata> =
    transform() { response ->
        response.ruleGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun NetworkFirewallClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun NetworkFirewallClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTlsInspectionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTlsInspectionConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTlsInspectionConfigurationsResponse]
 */
public fun NetworkFirewallClient.listTlsInspectionConfigurationsPaginated(initialRequest: ListTlsInspectionConfigurationsRequest = ListTlsInspectionConfigurationsRequest { }): Flow<ListTlsInspectionConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTlsInspectionConfigurationsPaginated.listTlsInspectionConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTlsInspectionConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTlsInspectionConfigurationsResponse]
 */
public fun NetworkFirewallClient.listTlsInspectionConfigurationsPaginated(block: ListTlsInspectionConfigurationsRequest.Builder.() -> Unit): Flow<ListTlsInspectionConfigurationsResponse> =
    listTlsInspectionConfigurationsPaginated(ListTlsInspectionConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTlsInspectionConfigurationsPaginated]
 * to access the nested member [TlsInspectionConfigurationMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TlsInspectionConfigurationMetadata]
 */
@JvmName("listTlsInspectionConfigurationsResponseTlsInspectionConfigurationMetadata")
public fun Flow<ListTlsInspectionConfigurationsResponse>.tlsInspectionConfigurations(): Flow<TlsInspectionConfigurationMetadata> =
    transform() { response ->
        response.tlsInspectionConfigurations?.forEach {
            emit(it)
        }
    }
