// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Configures the associated Certificate Manager Secure Sockets Layer/Transport Layer Security (SSL/TLS) server certificates and scope settings Network Firewall uses to decrypt traffic in a TLSInspectionConfiguration. For information about working with SSL/TLS certificates for TLS inspection, see [ Requirements for using SSL/TLS server certficiates with TLS inspection configurations](https://docs.aws.amazon.com/network-firewall/latest/developerguide/tls-inspection-certificate-requirements.html) in the *Network Firewall Developer Guide*.
 *
 * If a server certificate that's associated with your TLSInspectionConfiguration is revoked, deleted, or expired it can result in client-side TLS errors.
 */
public class ServerCertificateConfiguration private constructor(builder: Builder) {
    /**
     * A list of a server certificate configuration's scopes.
     */
    public val scopes: List<ServerCertificateScope>? = builder.scopes
    /**
     * The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
     */
    public val serverCertificates: List<ServerCertificate>? = builder.serverCertificates

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServerCertificateConfiguration(")
        append("scopes=$scopes,")
        append("serverCertificates=$serverCertificates")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = scopes?.hashCode() ?: 0
        result = 31 * result + (serverCertificates?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServerCertificateConfiguration

        if (scopes != other.scopes) return false
        if (serverCertificates != other.serverCertificates) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of a server certificate configuration's scopes.
         */
        public var scopes: List<ServerCertificateScope>? = null
        /**
         * The list of a server certificate configuration's Certificate Manager SSL/TLS certificates.
         */
        public var serverCertificates: List<ServerCertificate>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration) : this() {
            this.scopes = x.scopes
            this.serverCertificates = x.serverCertificates
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.ServerCertificateConfiguration = ServerCertificateConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
