// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * Additional settings for a stateful rule. This is part of the StatefulRule configuration.
 */
public class RuleOption private constructor(builder: Builder) {
    /**
     * The keyword for the Suricata compatible rule option. You must include a `sid` (signature ID), and can optionally include other keywords. For information about Suricata compatible keywords, see [Rule options](https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options) in the Suricata documentation.
     */
    public val keyword: kotlin.String = requireNotNull(builder.keyword) { "A non-null value must be provided for keyword" }
    /**
     * The settings of the Suricata compatible rule option. Rule options have zero or more setting values, and the number of possible and required settings depends on the `Keyword`. For more information about the settings for specific options, see [Rule options](https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options).
     */
    public val settings: List<String>? = builder.settings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.RuleOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleOption(")
        append("keyword=$keyword,")
        append("settings=$settings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyword.hashCode()
        result = 31 * result + (settings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleOption

        if (keyword != other.keyword) return false
        if (settings != other.settings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.RuleOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The keyword for the Suricata compatible rule option. You must include a `sid` (signature ID), and can optionally include other keywords. For information about Suricata compatible keywords, see [Rule options](https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options) in the Suricata documentation.
         */
        public var keyword: kotlin.String? = null
        /**
         * The settings of the Suricata compatible rule option. Rule options have zero or more setting values, and the number of possible and required settings depends on the `Keyword`. For more information about the settings for specific options, see [Rule options](https://suricata.readthedocs.io/en/suricata-6.0.9/rules/intro.html#rule-options).
         */
        public var settings: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.RuleOption) : this() {
            this.keyword = x.keyword
            this.settings = x.settings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.RuleOption = RuleOption(this)

        internal fun correctErrors(): Builder {
            if (keyword == null) keyword = ""
            return this
        }
    }
}
