// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.endpoints.internal

import aws.sdk.kotlin.services.networkfirewall.NetworkFirewallClient
import aws.sdk.kotlin.services.networkfirewall.endpoints.NetworkFirewallEndpointParameters
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest
import aws.smithy.kotlin.runtime.util.get

internal class EndpointResolverAdapter(
    private val config: NetworkFirewallClient.Config
): EndpointResolver {

    override suspend fun resolve(request: ResolveEndpointRequest): Endpoint {
        val params = resolveEndpointParams(config, request)
        val endpoint = config.endpointProvider.resolveEndpoint(params)
        return endpoint
    }
}

internal fun resolveEndpointParams(config: NetworkFirewallClient.Config, request: ResolveEndpointRequest): NetworkFirewallEndpointParameters {
    return NetworkFirewallEndpointParameters {
        bindAwsBuiltins(config, request)
        val opName = request.context[SdkClientOption.OperationName]
        opContextBindings[opName]?.invoke(this, request)
    }
}
private typealias BindOperationContextParamsFn = (NetworkFirewallEndpointParameters.Builder, ResolveEndpointRequest) -> Unit

private val opContextBindings = mapOf<String, BindOperationContextParamsFn> (
)

private fun NetworkFirewallEndpointParameters.Builder.bindAwsBuiltins(config: NetworkFirewallClient.Config, request: ResolveEndpointRequest) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
