// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The status of the firewall endpoint and firewall policy configuration for a single VPC subnet.
 *
 * For each VPC subnet that you associate with a firewall, Network Firewall does the following:
 * + Instantiates a firewall endpoint in the subnet, ready to take traffic.
 * + Configures the endpoint with the current firewall policy settings, to provide the filtering behavior for the endpoint.
 *
 * When you update a firewall, for example to add a subnet association or change a rule group in the firewall policy, the affected sync states reflect out-of-sync or not ready status until the changes are complete.
 */
public class SyncState private constructor(builder: Builder) {
    /**
     * The attachment status of the firewall's association with a single VPC subnet. For each configured subnet, Network Firewall creates the attachment by instantiating the firewall endpoint in the subnet so that it's ready to take traffic. This is part of the FirewallStatus.
     */
    public val attachment: aws.sdk.kotlin.services.networkfirewall.model.Attachment? = builder.attachment
    /**
     * The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall provides each endpoint with the rules that are configured in the firewall policy. Each time you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the rules in the endpoint, so it can properly filter network traffic. This is part of the FirewallStatus.
     */
    public val config: Map<String, PerObjectStatus>? = builder.config

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.SyncState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SyncState(")
        append("attachment=$attachment,")
        append("config=$config")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachment?.hashCode() ?: 0
        result = 31 * result + (config?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SyncState

        if (attachment != other.attachment) return false
        if (config != other.config) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.SyncState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The attachment status of the firewall's association with a single VPC subnet. For each configured subnet, Network Firewall creates the attachment by instantiating the firewall endpoint in the subnet so that it's ready to take traffic. This is part of the FirewallStatus.
         */
        public var attachment: aws.sdk.kotlin.services.networkfirewall.model.Attachment? = null
        /**
         * The configuration status of the firewall endpoint in a single VPC subnet. Network Firewall provides each endpoint with the rules that are configured in the firewall policy. Each time you add a subnet or modify the associated firewall policy, Network Firewall synchronizes the rules in the endpoint, so it can properly filter network traffic. This is part of the FirewallStatus.
         */
        public var config: Map<String, PerObjectStatus>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.SyncState) : this() {
            this.attachment = x.attachment
            this.config = x.config
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.SyncState = SyncState(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.Attachment] inside the given [block]
         */
        public fun attachment(block: aws.sdk.kotlin.services.networkfirewall.model.Attachment.Builder.() -> kotlin.Unit) {
            this.attachment = aws.sdk.kotlin.services.networkfirewall.model.Attachment.invoke(block)
        }
    }
}
