// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * High-level information about the managed rule group that your own rule group is copied from. You can use the the metadata to track version updates made to the originating rule group. You can retrieve all objects for a rule group by calling [DescribeRuleGroup](https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html).
 */
public class SourceMetadata private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The update token of the Amazon Web Services managed rule group that your own rule group is copied from. To determine the update token for the managed rule group, call [DescribeRuleGroup](https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken).
     */
    public val sourceUpdateToken: kotlin.String? = builder.sourceUpdateToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceMetadata(")
        append("sourceArn=$sourceArn,")
        append("sourceUpdateToken=$sourceUpdateToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceArn?.hashCode() ?: 0
        result = 31 * result + (sourceUpdateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceMetadata

        if (sourceArn != other.sourceArn) return false
        if (sourceUpdateToken != other.sourceUpdateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the rule group that your own rule group is copied from.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The update token of the Amazon Web Services managed rule group that your own rule group is copied from. To determine the update token for the managed rule group, call [DescribeRuleGroup](https://docs.aws.amazon.com/network-firewall/latest/APIReference/API_DescribeRuleGroup.html#networkfirewall-DescribeRuleGroup-response-UpdateToken).
         */
        public var sourceUpdateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata) : this() {
            this.sourceArn = x.sourceArn
            this.sourceUpdateToken = x.sourceUpdateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.SourceMetadata = SourceMetadata(this)
    }
}
