// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class ListRuleGroupsRequest private constructor(builder: Builder) {
    /**
     * Indicates the general category of the Amazon Web Services managed rule group.
     */
    public val managedType: aws.sdk.kotlin.services.networkfirewall.model.ResourceManagedType? = builder.managedType
    /**
     * The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The scope of the request. The default setting of `ACCOUNT` or a setting of `NULL` returns all of the rule groups in your account. A setting of `MANAGED` returns all available managed rule groups.
     */
    public val scope: aws.sdk.kotlin.services.networkfirewall.model.ResourceManagedStatus? = builder.scope
    /**
     * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
     */
    public val type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRuleGroupsRequest(")
        append("managedType=$managedType,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("scope=$scope,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = managedType?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRuleGroupsRequest

        if (managedType != other.managedType) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (scope != other.scope) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the general category of the Amazon Web Services managed rule group.
         */
        public var managedType: aws.sdk.kotlin.services.networkfirewall.model.ResourceManagedType? = null
        /**
         * The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The scope of the request. The default setting of `ACCOUNT` or a setting of `NULL` returns all of the rule groups in your account. A setting of `MANAGED` returns all available managed rule groups.
         */
        public var scope: aws.sdk.kotlin.services.networkfirewall.model.ResourceManagedStatus? = null
        /**
         * Indicates whether the rule group is stateless or stateful. If the rule group is stateless, it contains stateless rules. If it is stateful, it contains stateful rules.
         */
        public var type: aws.sdk.kotlin.services.networkfirewall.model.RuleGroupType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest) : this() {
            this.managedType = x.managedType
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.scope = x.scope
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.ListRuleGroupsRequest = ListRuleGroupsRequest(this)
    }
}
