// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



public class ListFirewallsRequest private constructor(builder: Builder) {
    /**
     * The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank to retrieve all firewalls that you have defined.
     */
    public val vpcIds: List<String>? = builder.vpcIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListFirewallsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("vpcIds=$vpcIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (vpcIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListFirewallsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (vpcIds != other.vpcIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of objects that you want Network Firewall to return for this request. If more objects are available, in the response, Network Firewall provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Network Firewall returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The unique identifiers of the VPCs that you want Network Firewall to retrieve the firewalls for. Leave this blank to retrieve all firewalls that you have defined.
         */
        public var vpcIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.vpcIds = x.vpcIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.ListFirewallsRequest = ListFirewallsRequest(this)
    }
}
