// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * The firewall policy defines the behavior of a firewall using a collection of stateless and stateful rule groups and other settings. You can use one firewall policy for multiple firewalls.
 *
 * This, along with FirewallPolicyResponse, define the policy. You can retrieve all objects for a firewall policy by calling DescribeFirewallPolicy.
 */
public class FirewallPolicy private constructor(builder: Builder) {
    /**
     * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.
     *
     * Valid values of the stateful default action:
     * + aws:drop_strict
     * + aws:drop_established
     * + aws:alert_strict
     * + aws:alert_established
     *
     * For more information, see [Strict evaluation order](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html) in the *Network Firewall Developer Guide*.
     */
    public val statefulDefaultActions: List<String>? = builder.statefulDefaultActions
    /**
     * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
     */
    public val statefulEngineOptions: aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions? = builder.statefulEngineOptions
    /**
     * References to the stateful rule groups that are used in the policy. These define the inspection criteria in stateful rules.
     */
    public val statefulRuleGroupReferences: List<StatefulRuleGroupReference>? = builder.statefulRuleGroupReferences
    /**
     * The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting. You name each custom action that you define, and then you can use it by name in your default actions specifications.
     */
    public val statelessCustomActions: List<CustomAction>? = builder.statelessCustomActions
    /**
     * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     *
     * You must specify one of the standard actions: `aws:pass`, `aws:drop`, or `aws:forward_to_sfe`. In addition, you can specify custom actions that are compatible with your standard section choice.
     *
     * For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", “customActionName”]`. For information about compatibility, see the custom action descriptions under CustomAction.
     */
    public val statelessDefaultActions: List<String>? = builder.statelessDefaultActions
    /**
     * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols. If you want non-matching fragmented UDP packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
     *
     * You must specify one of the standard actions: `aws:pass`, `aws:drop`, or `aws:forward_to_sfe`. In addition, you can specify custom actions that are compatible with your standard section choice.
     *
     * For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", “customActionName”]`. For information about compatibility, see the custom action descriptions under CustomAction.
     */
    public val statelessFragmentDefaultActions: List<String>? = builder.statelessFragmentDefaultActions
    /**
     * References to the stateless rule groups that are used in the policy. These define the matching criteria in stateless rules.
     */
    public val statelessRuleGroupReferences: List<StatelessRuleGroupReference>? = builder.statelessRuleGroupReferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FirewallPolicy(")
        append("statefulDefaultActions=$statefulDefaultActions,")
        append("statefulEngineOptions=$statefulEngineOptions,")
        append("statefulRuleGroupReferences=$statefulRuleGroupReferences,")
        append("statelessCustomActions=$statelessCustomActions,")
        append("statelessDefaultActions=$statelessDefaultActions,")
        append("statelessFragmentDefaultActions=$statelessFragmentDefaultActions,")
        append("statelessRuleGroupReferences=$statelessRuleGroupReferences")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = statefulDefaultActions?.hashCode() ?: 0
        result = 31 * result + (statefulEngineOptions?.hashCode() ?: 0)
        result = 31 * result + (statefulRuleGroupReferences?.hashCode() ?: 0)
        result = 31 * result + (statelessCustomActions?.hashCode() ?: 0)
        result = 31 * result + (statelessDefaultActions?.hashCode() ?: 0)
        result = 31 * result + (statelessFragmentDefaultActions?.hashCode() ?: 0)
        result = 31 * result + (statelessRuleGroupReferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FirewallPolicy

        if (statefulDefaultActions != other.statefulDefaultActions) return false
        if (statefulEngineOptions != other.statefulEngineOptions) return false
        if (statefulRuleGroupReferences != other.statefulRuleGroupReferences) return false
        if (statelessCustomActions != other.statelessCustomActions) return false
        if (statelessDefaultActions != other.statelessDefaultActions) return false
        if (statelessFragmentDefaultActions != other.statelessFragmentDefaultActions) return false
        if (statelessRuleGroupReferences != other.statelessRuleGroupReferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.
         *
         * Valid values of the stateful default action:
         * + aws:drop_strict
         * + aws:drop_established
         * + aws:alert_strict
         * + aws:alert_established
         *
         * For more information, see [Strict evaluation order](https://docs.aws.amazon.com/network-firewall/latest/developerguide/suricata-rule-evaluation-order.html#suricata-strict-rule-evaluation-order.html) in the *Network Firewall Developer Guide*.
         */
        public var statefulDefaultActions: List<String>? = null
        /**
         * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
         */
        public var statefulEngineOptions: aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions? = null
        /**
         * References to the stateful rule groups that are used in the policy. These define the inspection criteria in stateful rules.
         */
        public var statefulRuleGroupReferences: List<StatefulRuleGroupReference>? = null
        /**
         * The custom action definitions that are available for use in the firewall policy's `StatelessDefaultActions` setting. You name each custom action that you define, and then you can use it by name in your default actions specifications.
         */
        public var statelessCustomActions: List<CustomAction>? = null
        /**
         * The actions to take on a packet if it doesn't match any of the stateless rules in the policy. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
         *
         * You must specify one of the standard actions: `aws:pass`, `aws:drop`, or `aws:forward_to_sfe`. In addition, you can specify custom actions that are compatible with your standard section choice.
         *
         * For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", “customActionName”]`. For information about compatibility, see the custom action descriptions under CustomAction.
         */
        public var statelessDefaultActions: List<String>? = null
        /**
         * The actions to take on a fragmented UDP packet if it doesn't match any of the stateless rules in the policy. Network Firewall only manages UDP packet fragments and silently drops packet fragments for other protocols. If you want non-matching fragmented UDP packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
         *
         * You must specify one of the standard actions: `aws:pass`, `aws:drop`, or `aws:forward_to_sfe`. In addition, you can specify custom actions that are compatible with your standard section choice.
         *
         * For example, you could specify `["aws:pass"]` or you could specify `["aws:pass", “customActionName”]`. For information about compatibility, see the custom action descriptions under CustomAction.
         */
        public var statelessFragmentDefaultActions: List<String>? = null
        /**
         * References to the stateless rule groups that are used in the policy. These define the matching criteria in stateless rules.
         */
        public var statelessRuleGroupReferences: List<StatelessRuleGroupReference>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy) : this() {
            this.statefulDefaultActions = x.statefulDefaultActions
            this.statefulEngineOptions = x.statefulEngineOptions
            this.statefulRuleGroupReferences = x.statefulRuleGroupReferences
            this.statelessCustomActions = x.statelessCustomActions
            this.statelessDefaultActions = x.statelessDefaultActions
            this.statelessFragmentDefaultActions = x.statelessFragmentDefaultActions
            this.statelessRuleGroupReferences = x.statelessRuleGroupReferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.FirewallPolicy = FirewallPolicy(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions] inside the given [block]
         */
        public fun statefulEngineOptions(block: aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions.Builder.() -> kotlin.Unit) {
            this.statefulEngineOptions = aws.sdk.kotlin.services.networkfirewall.model.StatefulEngineOptions.invoke(block)
        }
    }
}
