// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.networkfirewall.model



/**
 * An optional, non-standard action to use for stateless packet handling. You can define this in addition to the standard action that you must specify.
 *
 * You define and name the custom actions that you want to be able to use, and then you reference them by name in your actions settings.
 *
 * You can use custom actions in the following places:
 * + In a rule group's StatelessRulesAndCustomActions specification. The custom actions are available for use by name inside the `StatelessRulesAndCustomActions` where you define them. You can use them for your stateless rule actions to specify what to do with a packet that matches the rule's match attributes.
 * + In a FirewallPolicy specification, in `StatelessCustomActions`. The custom actions are available for use inside the policy where you define them. You can use them for the policy's default stateless actions settings to specify what to do with packets that don't match any of the policy's stateless rules.
 */
public class CustomAction private constructor(builder: Builder) {
    /**
     * The custom action associated with the action name.
     */
    public val actionDefinition: aws.sdk.kotlin.services.networkfirewall.model.ActionDefinition? = builder.actionDefinition
    /**
     * The descriptive name of the custom action. You can't change the name of a custom action after you create it.
     */
    public val actionName: kotlin.String? = builder.actionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.networkfirewall.model.CustomAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomAction(")
        append("actionDefinition=$actionDefinition,")
        append("actionName=$actionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionDefinition?.hashCode() ?: 0
        result = 31 * result + (actionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomAction

        if (actionDefinition != other.actionDefinition) return false
        if (actionName != other.actionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.networkfirewall.model.CustomAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The custom action associated with the action name.
         */
        public var actionDefinition: aws.sdk.kotlin.services.networkfirewall.model.ActionDefinition? = null
        /**
         * The descriptive name of the custom action. You can't change the name of a custom action after you create it.
         */
        public var actionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.networkfirewall.model.CustomAction) : this() {
            this.actionDefinition = x.actionDefinition
            this.actionName = x.actionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.networkfirewall.model.CustomAction = CustomAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.networkfirewall.model.ActionDefinition] inside the given [block]
         */
        public fun actionDefinition(block: aws.sdk.kotlin.services.networkfirewall.model.ActionDefinition.Builder.() -> kotlin.Unit) {
            this.actionDefinition = aws.sdk.kotlin.services.networkfirewall.model.ActionDefinition.invoke(block)
        }
    }
}
